/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Function;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class PopulateLogoutPropagationContext
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    private static final String SESSION_PARAM_BYREF = "SessionKey";
    @Nonnull
    @NotEmpty
    private static final String SESSION_PARAM_BYVAL = "SPSession";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateLogoutPropagationContext.class);
    @Nullable
    private DataSealer dataSealer;
    @NonnullAfterInit
    private SPSessionSerializerRegistry spSessionSerializerRegistry;
    @Nonnull
    private Function<ProfileRequestContext, LogoutPropagationContext> contextCreationStrategy = new ChildContextLookup(LogoutPropagationContext.class, true);
    @Nullable
    private SPSession session;
    @Nullable
    private String sessionKey;

    public void setDataSealer(@Nullable DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = sealer;
    }

    public void setSPSessionSerializerRegistry(@Nonnull SPSessionSerializerRegistry registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.spSessionSerializerRegistry = (SPSessionSerializerRegistry)Constraint.isNotNull((Object)registry, (String)"Registry cannot be null");
    }

    public void setLogoutPropagationContextCreationStrategy(@Nonnull Function<ProfileRequestContext, LogoutPropagationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.contextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutPropagationContext creation strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.spSessionSerializerRegistry == null) {
            throw new ComponentInitializationException("SPSessionSerializerRegistry cannot be null");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        RequestContext requestContext = this.getRequestContext(profileRequestContext);
        if (requestContext == null) {
            this.log.error("{} Spring RequestContext is not set", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToDecode");
            return false;
        }
        String sessionRef = requestContext.getRequestParameters().get(SESSION_PARAM_BYREF);
        String sessionVal = requestContext.getRequestParameters().get(SESSION_PARAM_BYVAL);
        try {
            if (sessionRef != null) {
                this.sessionKey = sessionRef;
                this.session = this.getSessionByReference(requestContext, this.sessionKey);
            } else {
                if (sessionVal == null) {
                    this.log.warn("{} No session parameter provided, nothing to do", (Object)this.getLogPrefix());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToDecode");
                    return false;
                }
                if (this.dataSealer == null) {
                    this.log.error("{} No DataSealer provided, unable to decrypt session passed by value", (Object)this.getLogPrefix());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToDecode");
                    return false;
                }
                this.session = this.getSessionByValue(sessionVal);
            }
            this.log.debug("{} Got session to propagate logout: {}", (Object)this.getLogPrefix(), (Object)this.session);
            return true;
        }
        catch (MessageDecodingException e) {
            this.log.warn("{} Message decoding exception", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToDecode");
            return false;
        }
        catch (MessageException e) {
            this.log.warn("{} Required state not found", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        LogoutPropagationContext logoutPropCtx = (LogoutPropagationContext)this.contextCreationStrategy.apply((Object)profileRequestContext);
        if (logoutPropCtx == null) {
            this.log.error("{} Unable to create or locate SingleLogoutContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        logoutPropCtx.setSession(this.session);
        logoutPropCtx.setSessionKey(this.sessionKey);
    }

    @Nonnull
    private SPSession getSessionByReference(@Nonnull RequestContext requestContext, @Nonnull String key) throws MessageException {
        LogoutContext logoutCtx = (LogoutContext)requestContext.getExternalContext().getSessionMap().get("net.shibboleth.idp.session.impl.LogoutContext", LogoutContext.class);
        if (logoutCtx == null) {
            throw new MessageException("LogoutContext not found in HTTP session.");
        }
        SPSession s = (SPSession)logoutCtx.getKeyedSessionMap().get(key);
        if (s == null) {
            throw new MessageException("Session not found for key: " + key);
        }
        return s;
    }

    @Nonnull
    private SPSession getSessionByValue(@Nonnull String sessionVal) throws MessageDecodingException {
        try {
            String decrypted = this.dataSealer.unwrap(sessionVal);
            int pos = decrypted.indexOf(58);
            if (pos <= 0) {
                throw new MessageDecodingException("No class identifier found in decrypted message");
            }
            String sessionClassName = decrypted.substring(0, pos);
            StorageSerializer spSessionSerializer = this.spSessionSerializerRegistry.lookup(Class.forName(sessionClassName).asSubclass(SPSession.class));
            if (spSessionSerializer == null) {
                throw new MessageDecodingException("No serializer registered for session type: " + sessionClassName);
            }
            return (SPSession)spSessionSerializer.deserialize(1L, "session", "key", decrypted.substring(pos + 1), Long.valueOf(System.currentTimeMillis()));
        }
        catch (IOException | ClassNotFoundException | DataSealerException e) {
            throw new MessageDecodingException("Error deserializing encrypted SPSession", (Exception)e);
        }
    }
}

