/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Function;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectIdentitySwitch
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DetectIdentitySwitch.class);
    @NonnullAfterInit
    private SessionManager sessionManager;
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextLookupStrategy = new ChildContextLookup(SessionContext.class);
    @Nonnull
    private Function<ProfileRequestContext, SubjectCanonicalizationContext> c14nContextLookupStrategy = new ChildContextLookup(SubjectCanonicalizationContext.class);
    @Nullable
    private SessionContext sessionCtx;
    @Nullable
    private String newPrincipalName;

    public void setSessionManager(@Nonnull SessionManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionManager = (SessionManager)Constraint.isNotNull((Object)manager, (String)"SessionManager cannot be null");
    }

    public void setSessionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext lookup strategy cannot be null");
    }

    public void setSubjectCanonicalizationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectCanonicalizationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.c14nContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectCanonicalizationContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.sessionManager == null) {
            throw new ComponentInitializationException("SessionManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.sessionCtx = (SessionContext)this.sessionContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.sessionCtx == null || this.sessionCtx.getIdPSession() == null) {
            this.log.debug("{} No previous session found, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        SubjectCanonicalizationContext c14n = (SubjectCanonicalizationContext)this.c14nContextLookupStrategy.apply((Object)profileRequestContext);
        if (c14n == null || c14n.getPrincipalName() == null) {
            this.log.debug("{} Reusing identity from session, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.newPrincipalName = c14n.getPrincipalName();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.sessionCtx.getIdPSession().getPrincipalName().equals(this.newPrincipalName)) {
            this.log.debug("{} Identities from session and new authentication result match, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        this.log.info("{} Identity switch to {} detected, destroying original session {} for principal {}", new Object[]{this.getLogPrefix(), this.newPrincipalName, this.sessionCtx.getIdPSession().getId(), this.sessionCtx.getIdPSession().getPrincipalName()});
        try {
            this.sessionManager.destroySession(this.sessionCtx.getIdPSession().getId(), true);
        }
        catch (SessionException e) {
            this.log.error("{} Error destroying session {}", new Object[]{this.getLogPrefix(), this.sessionCtx.getIdPSession().getId(), e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
        this.sessionCtx.setIdPSession(null);
        authenticationContext.setActiveResults(Collections.emptyList());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"IdentitySwitch");
    }
}

