/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.util.Collections;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.ActionTestingSupport;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.idp.session.impl.BasicSPSessionSerializer;
import net.shibboleth.idp.session.impl.ProcessLogout;
import net.shibboleth.idp.session.impl.SessionManagerBaseTestCase;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProcessLogoutTest
extends SessionManagerBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private ProcessLogout action;

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.action = new ProcessLogout();
        this.action.setHttpServletRequest((HttpServletRequest)this.requestProxy);
        this.action.setHttpServletResponse((HttpServletResponse)this.responseProxy);
        this.action.setSessionResolver((SessionResolver)this.sessionManager);
        this.action.setSessionManager((SessionManager)this.sessionManager);
        this.action.initialize();
    }

    @Override
    protected void adjustProperties() throws ComponentInitializationException {
        this.sessionManager.setTrackSPSessions(true);
        this.sessionManager.setSecondaryServiceIndex(true);
        this.sessionManager.setSessionSlop(54000000L);
        SPSessionSerializerRegistry registry = new SPSessionSerializerRegistry();
        registry.setMappings(Collections.singletonMap(BasicSPSession.class, new BasicSPSessionSerializer(54000000L)));
        registry.initialize();
        this.sessionManager.setSPSessionSerializerRegistry(registry);
    }

    @Test
    public void testNoSession() {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(LogoutContext.class));
    }

    @Test
    public void testSessionNoSPSessions() throws SessionException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext subjectCtx = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectCtx);
        Assert.assertEquals((String)subjectCtx.getPrincipalName(), (String)"joe");
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class, true);
        Assert.assertTrue((boolean)logoutCtx.getSessionMap().isEmpty());
    }

    @Test
    public void testSessionSPSessions() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        long creation = System.currentTimeMillis();
        long expiration = creation + 216000000L;
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        session.addSPSession((SPSession)new BasicSPSession("https://sp.example.org", creation, expiration));
        session.addSPSession((SPSession)new BasicSPSession("https://sp2.example.org", creation, expiration));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext subjectCtx = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectCtx);
        Assert.assertEquals((String)subjectCtx.getPrincipalName(), (String)"joe");
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class, true);
        BasicSPSession sp = (BasicSPSession)logoutCtx.getSessions("https://sp.example.org").iterator().next();
        Assert.assertNotNull((Object)sp);
        Assert.assertEquals((long)sp.getCreationInstant(), (long)creation);
        Assert.assertEquals((long)sp.getExpirationInstant(), (long)expiration);
        sp = (BasicSPSession)logoutCtx.getSessions("https://sp2.example.org").iterator().next();
        Assert.assertNotNull((Object)sp);
        Assert.assertEquals((long)sp.getCreationInstant(), (long)creation);
        Assert.assertEquals((long)sp.getExpirationInstant(), (long)expiration);
    }

    @Test
    public void testAddressRebind() throws SessionException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setRemoteAddr("::1");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext subjectCtx = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectCtx);
        Assert.assertEquals((String)subjectCtx.getPrincipalName(), (String)"joe");
    }

    @Test
    public void testAddressMismatch() throws SessionException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setRemoteAddr("192.168.1.1");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(LogoutContext.class));
    }
}

