/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.ActionTestingSupport;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.impl.PopulateSessionContext;
import net.shibboleth.idp.session.impl.SessionManagerBaseTestCase;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateSessionContextTest
extends SessionManagerBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private PopulateSessionContext action;

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.action = new PopulateSessionContext();
        this.action.setHttpServletRequest((HttpServletRequest)this.requestProxy);
        this.action.setHttpServletResponse((HttpServletResponse)this.responseProxy);
        this.action.setSessionResolver((SessionResolver)this.sessionManager);
        this.action.initialize();
    }

    @Test
    public void testNoSession() {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class, false));
    }

    @Test
    public void testSession() throws SessionException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class, false);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertEquals((String)sessionCtx.getIdPSession().getPrincipalName(), (String)"joe");
    }

    @Test
    public void testAddressRebind() throws SessionException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setRemoteAddr("::1");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class, false);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertEquals((String)sessionCtx.getIdPSession().getPrincipalName(), (String)"joe");
    }

    @Test
    public void testAddressMismatch() throws SessionException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setRemoteAddr("192.168.1.1");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class, false));
    }

    @Test
    public void testTimeout() throws SessionException, InterruptedException {
        Cookie cookie = this.createSession("joe");
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Thread.sleep(10000L);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class, false));
    }
}

