/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.impl.BasicSPSessionSerializer;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicSPSessionSerializerTest {
    private static final String DATAPATH = "/net/shibboleth/idp/session/impl/";
    private static final long INSTANT = 1378827849463L;
    private static final String CONTEXT = "context";
    private static final String KEY = "key";
    private BasicSPSessionSerializer serializer;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.serializer = new BasicSPSessionSerializer(0L);
        this.serializer.initialize();
    }

    @Test
    public void testInvalid() throws Exception {
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/session/impl/invalid.json"), Long.valueOf(1378827849463L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/session/impl/noServiceId.json"), Long.valueOf(1378827849463L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/session/impl/noInstant.json"), Long.valueOf(1378827849463L));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serializer.deserialize(1L, CONTEXT, KEY, this.fileToString("/net/shibboleth/idp/session/impl/basicSPSession.json"), null);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBasic() throws Exception {
        long exp = 1378827909463L;
        BasicSPSession session = new BasicSPSession("test", 1378827849463L, exp);
        String s = this.serializer.serialize((SPSession)session);
        String s2 = this.fileToString("/net/shibboleth/idp/session/impl/basicSPSession.json");
        Assert.assertEquals((String)s, (String)s2);
        SPSession session2 = this.serializer.deserialize(1L, CONTEXT, KEY, s2, Long.valueOf(exp));
        Assert.assertEquals((String)session.getId(), (String)session2.getId());
        Assert.assertEquals((long)session.getCreationInstant(), (long)session2.getCreationInstant());
        Assert.assertEquals((long)session.getExpirationInstant(), (long)session2.getExpirationInstant());
    }

    private String fileToString(String pathname) throws URISyntaxException, IOException {
        try (FileInputStream stream = new FileInputStream(new File(BasicSPSessionSerializerTest.class.getResource(pathname).toURI()));){
            int avail = stream.available();
            byte[] data = new byte[avail];
            int numRead = 0;
            int pos = 0;
            do {
                if (pos + avail > data.length) {
                    byte[] newData = new byte[pos + avail];
                    System.arraycopy(data, 0, newData, 0, pos);
                    data = newData;
                }
                if ((numRead = stream.read(data, pos, avail)) < 0) continue;
                pos += numRead;
            } while ((avail = stream.available()) > 0 && numRead >= 0);
            String string = new String(data, 0, pos, "UTF-8");
            return string;
        }
    }
}

