/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.logic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.session.LogoutPropagationFlowDescriptor;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class LogoutPropagationFlowDescriptorSelector
implements Function<SPSession, LogoutPropagationFlowDescriptor> {
    private final List<LogoutPropagationFlowDescriptor> availableFlows;

    public LogoutPropagationFlowDescriptorSelector(@Nonnull @ParameterName(name="flows") @NonnullElements List<LogoutPropagationFlowDescriptor> flows) {
        Constraint.isNotNull(flows, (String)"Flows cannot be null");
        this.availableFlows = new ArrayList<LogoutPropagationFlowDescriptor>(Collections2.filter(flows, (Predicate)Predicates.notNull()));
    }

    @Nullable
    public LogoutPropagationFlowDescriptor apply(@Nonnull SPSession input) {
        for (LogoutPropagationFlowDescriptor flowDescriptor : this.availableFlows) {
            if (!flowDescriptor.getSessionType().isInstance(input)) continue;
            return flowDescriptor;
        }
        return null;
    }
}

