/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;

@ThreadSafe
public class BasicSPSession
implements SPSession {
    @Nonnull
    @NotEmpty
    private final String serviceId;
    @Duration
    @Positive
    private final long creationInstant;
    @Duration
    @Positive
    private final long expirationInstant;

    public BasicSPSession(@Nonnull @NotEmpty String id, @Duration @Positive long creation, @Duration @Positive long expiration) {
        this.serviceId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Service ID cannot be null nor empty");
        this.creationInstant = Constraint.isGreaterThan((long)0L, (long)creation, (String)"Creation instant must be greater than 0");
        this.expirationInstant = Constraint.isGreaterThan((long)0L, (long)expiration, (String)"Expiration instant must be greater than 0");
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.serviceId;
    }

    @Override
    @Duration
    @Positive
    public long getCreationInstant() {
        return this.creationInstant;
    }

    @Override
    @Duration
    @Positive
    public long getExpirationInstant() {
        return this.expirationInstant;
    }

    @Override
    public String getSPSessionKey() {
        return null;
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BasicSPSession) {
            return Objects.equals(this.serviceId, ((BasicSPSession)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.serviceId).add("creationInstant", (Object)new DateTime(this.creationInstant)).add("expirationInstant", (Object)new DateTime(this.expirationInstant)).toString();
    }
}

