/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.saml.saml2.profile.impl.SAMLAuthnContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinueSAMLAuthentication
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ContinueSAMLAuthentication.class);
    @Nullable
    private ExternalAuthenticationContext extContext;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.extContext = (ExternalAuthenticationContext)authenticationContext.getSubcontext(ExternalAuthenticationContext.class);
        if (this.extContext == null) {
            this.log.debug("{} No ExternalAuthenticationContext available within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.extContext.getAuthnError() != null) {
            this.log.info("{} SAML authentication attempt signaled an error: {}", (Object)this.getLogPrefix(), (Object)this.extContext.getAuthnError());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.extContext.getAuthnError());
        } else if (profileRequestContext.getInboundMessageContext() == null) {
            this.log.info("{} No inbound SAML Response found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
        } else if (!(profileRequestContext.getInboundMessageContext().getMessage() instanceof Response)) {
            this.log.info("{} Inbound message was not a SAML Response", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
        }
        Response response = (Response)profileRequestContext.getInboundMessageContext().getMessage();
        if (response.getStatus() == null || response.getStatus().getStatusCode() == null || response.getStatus().getStatusCode().getValue() == null) {
            this.log.info("{} SAML response did not contain a StatusCode", (Object)this.getLogPrefix());
            authenticationContext.removeSubcontext(SAMLAuthnContext.class);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
        } else if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
            this.log.info("{} SAML response contained error status: {}", (Object)this.getLogPrefix(), (Object)response.getStatus().getStatusCode().getValue());
            authenticationContext.removeSubcontext(SAMLAuthnContext.class);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
        }
    }
}

