/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedAssertionLookupStrategy
implements Function<ProfileRequestContext, Assertion> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DelegatedAssertionLookupStrategy.class);
    @Nonnull
    private Function<ProfileRequestContext, LibertySSOSContext> libertyContextLookupStrategy;

    public DelegatedAssertionLookupStrategy() {
        this.libertyContextLookupStrategy = new ChildContextLookup(LibertySSOSContext.class);
    }

    public DelegatedAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, LibertySSOSContext> strategy) {
        this.libertyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Liberty context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Assertion apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        LibertySSOSContext libertyContext = this.libertyContextLookupStrategy.apply(input);
        if (libertyContext == null || libertyContext.getAttestedToken() == null) {
            this.log.debug("No attested token available from Liberty context");
            return null;
        }
        return libertyContext.getAttestedToken();
    }
}

