/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.authn.principal.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDrivenAuthnContextTranslationStrategy
implements Function<AuthnContext, Collection<Principal>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MapDrivenAuthnContextTranslationStrategy.class);
    @Nonnull
    @NonnullElements
    private Map<Principal, Collection<Principal>> principalMappings = Collections.emptyMap();

    public void setMappings(@Nullable @NonnullElements Map<Principal, Collection<Principal>> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            this.principalMappings = Collections.emptyMap();
            return;
        }
        this.principalMappings = new HashMap<Principal, Collection<Principal>>(mappings.size());
        mappings.forEach((k, v) -> this.principalMappings.put((Principal)k, List.copyOf(v)));
    }

    @Override
    @Nullable
    public Collection<Principal> apply(@Nullable AuthnContext input) {
        if (input != null) {
            AuthnContextClassRefPrincipal principal;
            if (input.getAuthnContextClassRef() != null && input.getAuthnContextClassRef().getURI() != null) {
                principal = new AuthnContextClassRefPrincipal(input.getAuthnContextClassRef().getURI());
            } else if (input.getAuthnContextDeclRef() != null && input.getAuthnContextDeclRef().getURI() != null) {
                principal = new AuthnContextDeclRefPrincipal(input.getAuthnContextDeclRef().getURI());
            } else {
                this.log.trace("Input AuthnContext did not contain a class or decl reference, returning nothing");
                return null;
            }
            if (this.principalMappings.containsKey(principal)) {
                Collection<Principal> mapped = this.principalMappings.get(principal);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Mapped '{}' to ", (Object)principal.getName(), mapped.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
                }
                return mapped;
            }
            this.log.trace("Passing unmapped value '{}' through", (Object)principal.getName());
            return Collections.singletonList(principal);
        }
        this.log.trace("Input AuthnContext was null, returning nothing");
        return null;
    }
}

