/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;

public class AuthnContextAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public AuthnContextAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        block6: {
            SAMLObject response;
            block7: {
                response = this.responseLookupStrategy.apply(input);
                if (response == null) break block6;
                if (response instanceof ArtifactResponse) {
                    response = ((ArtifactResponse)response).getMessage();
                }
                if (!(response instanceof org.opensaml.saml.saml2.core.Response)) break block7;
                for (org.opensaml.saml.saml2.core.Assertion assertion : ((org.opensaml.saml.saml2.core.Response)response).getAssertions()) {
                    for (AuthnStatement statement : assertion.getAuthnStatements()) {
                        if (statement.getAuthnContext() == null) continue;
                        AuthnContext ac = statement.getAuthnContext();
                        if (ac.getAuthnContextClassRef() != null) {
                            return ac.getAuthnContextClassRef().getURI();
                        }
                        if (ac.getAuthnContextDeclRef() == null) continue;
                        return ac.getAuthnContextDeclRef().getURI();
                    }
                }
                break block6;
            }
            if (!(response instanceof Response)) break block6;
            for (Assertion assertion : ((Response)response).getAssertions()) {
                for (AuthenticationStatement statement : assertion.getAuthenticationStatements()) {
                    if (statement.getAuthenticationMethod() == null) continue;
                    return statement.getAuthenticationMethod();
                }
            }
        }
        return null;
    }
}

