/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl.SAMLSOAPDecoderBodyHandler;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibertyHTTPSOAP11Decoder
extends BaseHttpServletRequestXMLMessageDecoder<SAMLObject>
implements SAMLMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LibertyHTTPSOAP11Decoder.class);
    @Nullable
    private BindingDescriptor bindingDescriptor;
    private MessageHandler<SAMLObject> bodyHandler;

    public LibertyHTTPSOAP11Decoder() {
        this.setBodyHandler((MessageHandler<SAMLObject>)new SAMLSOAPDecoderBodyHandler());
    }

    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:liberty:sb:2006-08";
    }

    @Nullable
    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    public void setBindingDescriptor(@Nullable BindingDescriptor descriptor) {
        this.bindingDescriptor = descriptor;
    }

    public MessageHandler<SAMLObject> getBodyHandler() {
        return this.bodyHandler;
    }

    public void setBodyHandler(MessageHandler<SAMLObject> newBodyHandler) {
        this.bodyHandler = newBodyHandler;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getBodyHandler() == null) {
            throw new ComponentInitializationException("Body handler MessageHandler cannot be null");
        }
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP POST method");
        }
        this.log.debug("Unmarshalling SOAP message");
        try {
            Envelope soapMessage = (Envelope)this.unmarshallMessage((InputStream)request.getInputStream());
            ((SOAP11Context)messageContext.getSubcontext(SOAP11Context.class, true)).setEnvelope(soapMessage);
        }
        catch (IOException e) {
            this.log.error("Unable to obtain input stream from HttpServletRequest", (Throwable)e);
            throw new MessageDecodingException("Unable to obtain input stream from HttpServletRequest", (Exception)e);
        }
        try {
            this.getBodyHandler().invoke(messageContext);
        }
        catch (MessageHandlerException e) {
            this.log.error("Error processing SOAP Envelope body", (Throwable)e);
            throw new MessageDecodingException("Error processing SOAP Envelope body", (Exception)((Object)e));
        }
        if (messageContext.getMessage() == null) {
            this.log.warn("Body handler did not properly populate the message in message context");
            throw new MessageDecodingException("Body handler did not properly populate the message in message context");
        }
        this.setMessageContext(messageContext);
        this.populateBindingContext((MessageContext<SAMLObject>)this.getMessageContext());
        SAMLObject samlMessage = (SAMLObject)this.getMessageContext().getMessage();
        this.log.debug("Decoded SOAP message which included SAML message of type {}", (Object)samlMessage.getElementQName());
    }

    protected void populateBindingContext(MessageContext<SAMLObject> messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setBindingDescriptor(this.bindingDescriptor);
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }

    protected XMLObject getMessageToLog() {
        return ((SOAP11Context)this.getMessageContext().getSubcontext(SOAP11Context.class, true)).getEnvelope();
    }
}

