/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.metrics.ReloadableServiceGaugeSet;
import net.shibboleth.idp.saml.metadata.RelyingPartyMetadataProvider;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.joda.time.DateTime;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.ExtendedBatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.ExtendedRefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;

public class MetadataResolverServiceGaugeSet
extends ReloadableServiceGaugeSet
implements MetricSet,
MetricFilter {
    public MetadataResolverServiceGaugeSet(@Nonnull @ParameterName(name="metricName") @NotEmpty String metricName) {
        super(metricName);
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "update"}), new Gauge<Map<String, DateTime>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, DateTime> getValue() {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                ServiceableComponent component = MetadataResolverServiceGaugeSet.this.getService().getServiceableComponent();
                if (component != null) {
                    try {
                        for (MetadataResolver resolver : MetadataResolverServiceGaugeSet.this.getMetadataResolvers((MetadataResolver)component.getComponent())) {
                            if (!(resolver instanceof RefreshableMetadataResolver) || ((RefreshableMetadataResolver)resolver).getLastUpdate() == null) continue;
                            mapBuilder.put((Object)resolver.getId(), (Object)((RefreshableMetadataResolver)resolver).getLastUpdate());
                        }
                    }
                    finally {
                        component.unpinComponent();
                    }
                }
                return mapBuilder.build();
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "refresh"}), new Gauge<Map<String, DateTime>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, DateTime> getValue() {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                ServiceableComponent component = MetadataResolverServiceGaugeSet.this.getService().getServiceableComponent();
                if (component != null) {
                    try {
                        for (MetadataResolver resolver : MetadataResolverServiceGaugeSet.this.getMetadataResolvers((MetadataResolver)component.getComponent())) {
                            if (!(resolver instanceof RefreshableMetadataResolver) || ((RefreshableMetadataResolver)resolver).getLastRefresh() == null) continue;
                            mapBuilder.put((Object)resolver.getId(), (Object)((RefreshableMetadataResolver)resolver).getLastRefresh());
                        }
                    }
                    finally {
                        component.unpinComponent();
                    }
                }
                return mapBuilder.build();
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "successfulRefresh"}), new Gauge<Map<String, DateTime>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, DateTime> getValue() {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                ServiceableComponent component = MetadataResolverServiceGaugeSet.this.getService().getServiceableComponent();
                if (component != null) {
                    try {
                        for (MetadataResolver resolver : MetadataResolverServiceGaugeSet.this.getMetadataResolvers((MetadataResolver)component.getComponent())) {
                            if (!(resolver instanceof ExtendedRefreshableMetadataResolver) || ((ExtendedRefreshableMetadataResolver)resolver).getLastSuccessfulRefresh() == null) continue;
                            mapBuilder.put((Object)resolver.getId(), (Object)((ExtendedRefreshableMetadataResolver)resolver).getLastSuccessfulRefresh());
                        }
                    }
                    finally {
                        component.unpinComponent();
                    }
                }
                return mapBuilder.build();
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "rootValidUntil"}), new Gauge<Map<String, DateTime>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, DateTime> getValue() {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                ServiceableComponent component = MetadataResolverServiceGaugeSet.this.getService().getServiceableComponent();
                if (component != null) {
                    try {
                        for (MetadataResolver resolver : MetadataResolverServiceGaugeSet.this.getMetadataResolvers((MetadataResolver)component.getComponent())) {
                            if (!(resolver instanceof ExtendedBatchMetadataResolver) || ((ExtendedBatchMetadataResolver)resolver).getRootValidUntil() == null) continue;
                            mapBuilder.put((Object)resolver.getId(), (Object)((ExtendedBatchMetadataResolver)resolver).getRootValidUntil());
                        }
                    }
                    finally {
                        component.unpinComponent();
                    }
                }
                return mapBuilder.build();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        ServiceableComponent component = this.getService().getServiceableComponent();
        if (component != null) {
            try {
                if (component instanceof MetadataResolver) {
                    return;
                }
            }
            finally {
                component.unpinComponent();
            }
        }
        throw new ComponentInitializationException("Injected service was null or not a MetadataResolver");
    }

    @Nonnull
    @NonnullElements
    private Iterable<MetadataResolver> getMetadataResolvers(@Nonnull MetadataResolver rootResolver) {
        MetadataResolver root = rootResolver;
        if (root instanceof RelyingPartyMetadataProvider) {
            root = ((RelyingPartyMetadataProvider)root).getEmbeddedResolver();
        }
        if (root instanceof ChainingMetadataResolver) {
            return ((ChainingMetadataResolver)root).getResolvers();
        }
        return Collections.singletonList(root);
    }
}

