/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.StatusMessage;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class StatusMessageAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public StatusMessageAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject response = (SAMLObject)this.responseLookupStrategy.apply((Object)input);
        if (response != null) {
            if (response instanceof Response) {
                StatusMessage msg;
                StatusMessage statusMessage = msg = ((Response)response).getStatus() != null ? ((Response)response).getStatus().getStatusMessage() : null;
                if (msg != null) {
                    return msg.getMessage();
                }
            } else if (response instanceof StatusResponseType) {
                org.opensaml.saml.saml2.core.StatusMessage msg;
                org.opensaml.saml.saml2.core.StatusMessage statusMessage = msg = ((StatusResponseType)response).getStatus() != null ? ((StatusResponseType)response).getStatus().getStatusMessage() : null;
                if (msg != null) {
                    return msg.getMessage();
                }
            }
        }
        return null;
    }
}

