/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.idwsf.profile.config.SSOSProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.DelegatedAssertionLookupStrategy;
import net.shibboleth.idp.saml.xmlobject.DelegationPolicy;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.opensaml.saml.saml2.core.Advice;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
public class EvaluateDelegationPolicy
extends AbstractProfileAction {
    public static final Long DEFAULT_POLICY_MAX_CHAIN_LENGTH = 1L;
    private Logger log = LoggerFactory.getLogger(EvaluateDelegationPolicy.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, Assertion> assertionTokenStrategy = new DelegatedAssertionLookupStrategy();
    @Nonnull
    private Function<ProfileRequestContext, Long> policyMaxChainLengthStrategy = new PolicyMaxChainLengthStrategy();
    private Assertion assertionToken;
    private Long policyMaxChainLength;
    private Long tokenChainLength;
    private Predicate<ProfileRequestContext> delegationPredicate;

    public void setPolicyMaxChainLengthStrategy(@Nonnull Function<ProfileRequestContext, Long> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.policyMaxChainLengthStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy max chain length strategy may not be null");
    }

    public void setAssertionTokenStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionTokenStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion token strategy may not be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy may not be null");
    }

    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (!this.doPreExecuteInbound(profileRequestContext)) {
            return false;
        }
        return this.doPreExecuteRelyingParty(profileRequestContext);
    }

    protected boolean doPreExecuteInbound(@Nonnull ProfileRequestContext profileRequestContext) {
        this.assertionToken = (Assertion)this.assertionTokenStrategy.apply((Object)profileRequestContext);
        if (this.assertionToken == null) {
            this.log.warn("{} No valid SAML 2 Assertion available within the request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        this.tokenChainLength = this.getTokenDelegationChainLength(this.assertionToken);
        this.policyMaxChainLength = this.getPolicyMaxDelegationChainLength(profileRequestContext);
        return true;
    }

    protected boolean doPreExecuteRelyingParty(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext relyingPartyContext = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)profileRequestContext);
        if (relyingPartyContext == null) {
            this.log.warn("No RelyingPartyContext was available");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (!(relyingPartyContext.getProfileConfig() instanceof SSOSProfileConfiguration)) {
            this.log.warn("Relying party profile configuration was not SSOSProfileConfiguration");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.delegationPredicate = ((SSOSProfileConfiguration)relyingPartyContext.getProfileConfig()).getDelegationPredicate();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.checkAllowedDelegate(profileRequestContext)) {
            return;
        }
        this.checkTokenDelegationChainLength(profileRequestContext);
    }

    protected boolean checkAllowedDelegate(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.delegationPredicate.apply((Object)profileRequestContext)) {
            this.log.warn("Delegation predicate eval indicates delegated token use NOT allowed");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        this.log.debug("Delegation predicate eval indicates delegated token use is allowed");
        return true;
    }

    protected boolean checkTokenDelegationChainLength(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.tokenChainLength == null || this.tokenChainLength <= 0L) {
            this.log.debug("Token did not have delegation chain, this must be initial delegation request, check passes");
            return true;
        }
        this.log.debug("Token delegation chain length was '{}', policy max was '{}'", (Object)this.tokenChainLength, (Object)this.policyMaxChainLength);
        if (this.tokenChainLength < this.policyMaxChainLength) {
            this.log.debug("Token delegation chain length is OK");
            return true;
        }
        if (this.tokenChainLength > this.policyMaxChainLength) {
            this.log.warn("Presented token delegation chain length exceeds policy max, and fails acceptance");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        if (this.tokenChainLength.equals(this.policyMaxChainLength)) {
            this.log.warn("Token delegation chain length is equal to policy max, can't issue a new token from this token");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        return true;
    }

    protected Long getTokenDelegationChainLength(@Nonnull Assertion token) {
        DelegationRestrictionType delRestrict = this.getDelegationRestrictionCondition(token.getConditions());
        if (delRestrict != null && delRestrict.getDelegates() != null) {
            return delRestrict.getDelegates().size();
        }
        return null;
    }

    protected DelegationRestrictionType getDelegationRestrictionCondition(@Nullable Conditions conditions) {
        if (conditions == null) {
            return null;
        }
        for (Condition conditionChild : conditions.getConditions()) {
            if (!DelegationRestrictionType.TYPE_NAME.equals(conditionChild.getSchemaType())) continue;
            if (conditionChild instanceof DelegationRestrictionType) {
                return (DelegationRestrictionType)conditionChild;
            }
            this.log.warn("Saw Condition of xsi:type DelegationRestrictionType, but incorrect class instance: {}", (Object)conditionChild.getClass().getName());
        }
        return null;
    }

    @Nonnull
    protected Long getPolicyMaxDelegationChainLength(@Nonnull ProfileRequestContext profileRequestContext) {
        Long value = (Long)this.policyMaxChainLengthStrategy.apply((Object)profileRequestContext);
        if (value != null) {
            this.log.debug("Strategy resolved policy max token delegation chain length: {}", (Object)value);
            return value;
        }
        this.log.debug("Returning default policy max token delegation chain length: {}", (Object)DEFAULT_POLICY_MAX_CHAIN_LENGTH);
        return DEFAULT_POLICY_MAX_CHAIN_LENGTH;
    }

    public class PolicyMaxChainLengthStrategy
    implements Function<ProfileRequestContext, Long> {
        @Nullable
        public Long apply(@Nullable ProfileRequestContext input) {
            if (EvaluateDelegationPolicy.this.assertionToken == null || EvaluateDelegationPolicy.this.assertionToken.getAdvice() == null) {
                return null;
            }
            Advice inboundAdvice = EvaluateDelegationPolicy.this.assertionToken.getAdvice();
            List inboundPolicies = inboundAdvice.getChildren(DelegationPolicy.DEFAULT_ELEMENT_NAME);
            if (inboundPolicies != null && !inboundPolicies.isEmpty()) {
                return ((DelegationPolicy)inboundPolicies.get(0)).getMaximumTokenDelegationChainLength();
            }
            return null;
        }
    }
}

