/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.relyingparty.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.logic.RelyingPartyIdPredicate;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.StrategyIndirectedPredicate;
import org.opensaml.saml.common.messaging.context.navigate.EntityDescriptorLookupFunction;
import org.opensaml.saml.common.profile.logic.EntityAttributesPredicate;
import org.opensaml.saml.common.profile.logic.EntityGroupNamePredicate;

public final class RelyingPartyConfigurationSupport {
    private RelyingPartyConfigurationSupport() {
    }

    @Nonnull
    public static RelyingPartyConfiguration byName(@Nonnull @NonnullElements Collection<String> relyingPartyIds) {
        Constraint.isNotNull(relyingPartyIds, (String)"Relying Party ID list cannot be null");
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setActivationCondition((Predicate)new RelyingPartyIdPredicate(relyingPartyIds));
        StringBuffer name = new StringBuffer("EntityNames[");
        for (String rpId : relyingPartyIds) {
            name.append(rpId).append(',');
        }
        name.append(']');
        config.setId(name.toString());
        return config;
    }

    @Nonnull
    public static RelyingPartyConfiguration byGroup(@Nonnull @NonnullElements Collection<String> groupNames) {
        Constraint.isNotNull(groupNames, (String)"Group name list cannot be null");
        StrategyIndirectedPredicate indirectPredicate = new StrategyIndirectedPredicate(Functions.compose((Function)new EntityDescriptorLookupFunction(), (Function)new SAMLMetadataContextLookupFunction()), (Predicate)new EntityGroupNamePredicate(groupNames));
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setActivationCondition((Predicate)indirectPredicate);
        StringBuffer name = new StringBuffer("EntityGroups[");
        for (String group : groupNames) {
            name.append(group).append(',');
        }
        name.append(']');
        config.setId(name.toString());
        return config;
    }

    @Nonnull
    public static RelyingPartyConfiguration byTag(@Nonnull @NonnullElements Collection<EntityAttributesPredicate.Candidate> candidates, boolean trim) {
        Constraint.isNotNull(candidates, (String)"Candidate list cannot be null");
        StrategyIndirectedPredicate indirectPredicate = new StrategyIndirectedPredicate(Functions.compose((Function)new EntityDescriptorLookupFunction(), (Function)new SAMLMetadataContextLookupFunction()), (Predicate)new EntityAttributesPredicate(candidates, trim));
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setActivationCondition((Predicate)indirectPredicate);
        return config;
    }
}

