/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.AuthnStatement;

public class AuthnInstantAuditExtractor
implements Function<ProfileRequestContext, DateTime> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public AuthnInstantAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Nullable
    public DateTime apply(@Nullable ProfileRequestContext input) {
        block5: {
            SAMLObject response;
            block6: {
                response = (SAMLObject)this.responseLookupStrategy.apply((Object)input);
                if (response == null) break block5;
                if (response instanceof ArtifactResponse) {
                    response = ((ArtifactResponse)response).getMessage();
                }
                if (!(response instanceof org.opensaml.saml.saml2.core.Response)) break block6;
                for (org.opensaml.saml.saml2.core.Assertion assertion : ((org.opensaml.saml.saml2.core.Response)response).getAssertions()) {
                    for (AuthnStatement statement : assertion.getAuthnStatements()) {
                        if (statement.getAuthnInstant() == null) continue;
                        return statement.getAuthnInstant();
                    }
                }
                break block5;
            }
            if (!(response instanceof Response)) break block5;
            for (Assertion assertion : ((Response)response).getAssertions()) {
                for (AuthenticationStatement statement : assertion.getAuthenticationStatements()) {
                    if (statement.getAuthenticationInstant() == null) continue;
                    return statement.getAuthenticationInstant();
                }
            }
        }
        return null;
    }
}

