/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.config.navigate.IdentifierGenerationStrategyLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAddAuthenticationStatementToAssertion
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseAddAuthenticationStatementToAssertion.class);
    private boolean statementInOwnAssertion = false;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = new IdentifierGenerationStrategyLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new ResponderIdLookupFunction();
    @Nullable
    private AuthenticationResult authenticationResult;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private String issuerId;

    public boolean isStatementInOwnAssertion() {
        return this.statementInOwnAssertion;
    }

    public void setStatementInOwnAssertion(boolean inOwnAssertion) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.statementInOwnAssertion = inOwnAssertion;
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @Nonnull
    public AuthenticationResult getAuthenticationResult() {
        Constraint.isNotNull((Object)this.authenticationResult, (String)"AuthenticationResult has not been initialized yet");
        return this.authenticationResult;
    }

    @Nonnull
    public IdentifierGenerationStrategy getIdGenerator() {
        Constraint.isNotNull((Object)this.idGenerator, (String)"IdentifierGenerationStrategy has not been initialized yet");
        return this.idGenerator;
    }

    @Nonnull
    public String getIssuerId() {
        Constraint.isNotNull((Object)this.issuerId, (String)"Issuer name has not been initialized yet");
        return this.issuerId;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.log.debug("{} Attempting to add an AuthenticationStatement to outgoing Assertion", (Object)this.getLogPrefix());
        this.idGenerator = (IdentifierGenerationStrategy)this.idGeneratorLookupStrategy.apply((Object)profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.issuerId = (String)this.issuerLookupStrategy.apply((Object)profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No assertion issuer value", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.authenticationResult = authenticationContext.getAuthenticationResult();
        if (this.authenticationResult == null) {
            this.log.debug("{} No AuthenticationResult in current authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }
}

