/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.nameid.NameIdentifierAttributeEncoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.profile.NameIdentifierGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyNameIdentifierGenerator<NameIdType extends SAMLObject>
extends AbstractIdentifiableInitializableComponent
implements NameIdentifierGenerator<NameIdType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LegacyNameIdentifierGenerator.class);
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nonnull
    private Class<? extends NameIdentifierAttributeEncoder> encoderType;

    protected LegacyNameIdentifierGenerator(@Nonnull Class<? extends NameIdentifierAttributeEncoder> clazz) {
        this.encoderType = (Class)Constraint.isNotNull(clazz, (String)"Encoder class type cannot be null");
        this.attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    @Nullable
    public NameIdType generate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String format) throws SAMLException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)format, (String)"Format cannot be null or empty");
        if (!this.activationCondition.apply((Object)profileRequestContext)) {
            return null;
        }
        AttributeContext attributeContext = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (attributeContext == null || attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("No AttributeContext or resolved IdPAttributes found, nothing to do");
            return null;
        }
        for (IdPAttribute idpAttribute : attributeContext.getIdPAttributes().values()) {
            if (idpAttribute.getValues().isEmpty()) continue;
            for (AttributeEncoder encoder : idpAttribute.getEncoders()) {
                if (!this.encoderType.isInstance(encoder) || !((NameIdentifierAttributeEncoder)encoder).apply((Object)format) || !encoder.getActivationCondition().apply((Object)profileRequestContext)) continue;
                try {
                    SAMLObject nameId = (SAMLObject)encoder.encode(idpAttribute);
                    this.log.debug("Encoded attribute {} into name identifier with format {}", (Object)idpAttribute.getId(), (Object)format);
                    return (NameIdType)nameId;
                }
                catch (AttributeEncodingException e) {
                    this.log.error("Error encoding IdPAttribute into name identifier", (Throwable)e);
                }
            }
        }
        this.log.debug("Unable to obtain name identifier from legacy attribute encoders");
        return null;
    }
}

