/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class SubStatusCodeAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public SubStatusCodeAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Nullable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        SAMLObject response = (SAMLObject)this.responseLookupStrategy.apply((Object)input);
        if (response != null) {
            if (response instanceof Response) {
                org.opensaml.saml.saml1.core.StatusCode sc;
                org.opensaml.saml.saml1.core.StatusCode statusCode = sc = ((Response)response).getStatus() != null ? ((Response)response).getStatus().getStatusCode() : null;
                if (sc != null && sc.getStatusCode() != null) {
                    ArrayList values = Lists.newArrayListWithExpectedSize((int)1);
                    do {
                        if ((sc = sc.getStatusCode()).getValue() == null) continue;
                        values.add(sc.getValue().getLocalPart());
                    } while (sc.getStatusCode() != null);
                    return values;
                }
            } else if (response instanceof StatusResponseType) {
                StatusCode sc;
                StatusCode statusCode = sc = ((StatusResponseType)response).getStatus() != null ? ((StatusResponseType)response).getStatus().getStatusCode() : null;
                if (sc != null && sc.getStatusCode() != null) {
                    ArrayList values = Lists.newArrayListWithExpectedSize((int)1);
                    do {
                        if ((sc = sc.getStatusCode()).getValue() == null) continue;
                        values.add(sc.getValue());
                    } while (sc.getStatusCode() != null);
                    return values;
                }
            }
        }
        return Collections.emptyList();
    }
}

