/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.AbstractSAML2ArtifactAwareProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoConfidentialityMessageChannelPredicate;
import org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate;

public class SingleLogoutProfileConfiguration
extends AbstractSAML2ArtifactAwareProfileConfiguration {
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml2/logout";
    @Nullable
    private Function<ProfileRequestContext, Collection<String>> qualifiedNameIDFormatsLookupStrategy;
    @Nonnull
    @NonnullElements
    private Collection<String> qualifiedNameIDFormats;

    public SingleLogoutProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected SingleLogoutProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignRequests((Predicate<ProfileRequestContext>)new NoIntegrityMessageChannelPredicate());
        this.setSignResponses((Predicate<ProfileRequestContext>)new NoIntegrityMessageChannelPredicate());
        this.setEncryptNameIDs((Predicate<ProfileRequestContext>)new NoConfidentialityMessageChannelPredicate());
        this.qualifiedNameIDFormats = Collections.emptyList();
    }

    public Collection<String> getQualifiedNameIDFormats() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.qualifiedNameIDFormatsLookupStrategy, this.qualifiedNameIDFormats)));
    }

    public void setQualifiedNameIDFormats(@Nullable @NonnullElements Collection<String> formats) {
        this.qualifiedNameIDFormats = formats == null ? Collections.emptyList() : StringSupport.normalizeStringCollection(formats);
    }

    public void setQualifiedNameIDFormatsLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<String>> strategy) {
        this.qualifiedNameIDFormatsLookupStrategy = strategy;
    }
}

