/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.context.navigate.messaging.SAMLMetadataContextLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ProfileIdLookup;
import org.opensaml.saml.common.messaging.context.navigate.EntityDescriptorLookupFunction;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.soap.client.security.SOAPClientSecurityProfileIdLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetadataDrivenConfigurationLookupStrategy<T>
extends AbstractInitializableComponent
implements Function<BaseContext, T> {
    @Nonnull
    private static final Function<ProfileRequestContext, EntityDescriptor> DEFAULT_PRC_METADATA_LOOKUP = Functions.compose((Function)new EntityDescriptorLookupFunction(), (Function)new net.shibboleth.idp.saml.profile.context.navigate.SAMLMetadataContextLookupFunction());
    @Nonnull
    private static final Function<ProfileRequestContext, String> DEFAULT_PRC_PROFILE_ID_LOOKUP = new ProfileIdLookup();
    @Nonnull
    private static final Function<MessageContext, EntityDescriptor> DEFAULT_MC_METADATA_LOOKUP = Functions.compose((Function)new EntityDescriptorLookupFunction(), (Function)new SAMLMetadataContextLookupFunction());
    @Nonnull
    private static final Function<MessageContext, String> DEFAULT_MC_PROFILE_ID_LOOKUP = new SOAPClientSecurityProfileIdLookupFunction();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataDrivenConfigurationLookupStrategy.class);
    private boolean strictNameFormat;
    private boolean enableCaching = true;
    @NonnullAfterInit
    @NotEmpty
    private String propertyName;
    @NonnullAfterInit
    @NonnullElements
    private Collection<String> propertyAliases;
    @Nullable
    private Function<BaseContext, EntityDescriptor> metadataLookupStrategy;
    @Nullable
    @NotEmpty
    private Function<BaseContext, String> profileIdLookupStrategy;

    public void setStrictNameFormat(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.strictNameFormat = flag;
    }

    public void setEnableCaching(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.enableCaching = flag;
    }

    public void setPropertyName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.propertyName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Property name cannot be null or empty");
    }

    public void setProfileAliases(@Nonnull @NonnullElements Collection<String> aliases) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(aliases, (String)"Alias collection cannot be null");
        this.propertyAliases = new ArrayList<String>(StringSupport.normalizeStringCollection(aliases));
    }

    public void setMetadataLookupStrategy(@Nonnull Function<BaseContext, EntityDescriptor> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Metadata lookup strategy cannot be null");
    }

    public void setProfileIdLookupStrategy(@Nonnull Function<BaseContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Profile ID lookup strategy cannot be null");
    }

    @Nullable
    public T apply(@Nullable BaseContext input) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        CachedConfigurationContext cacheContext = null;
        if (this.enableCaching && input != null && (cacheContext = (CachedConfigurationContext)input.getSubcontext(CachedConfigurationContext.class, true)).getPropertyMap().containsKey(this.propertyName)) {
            this.log.debug("Returning cached property '{}'", (Object)this.propertyName);
            return (T)cacheContext.getPropertyMap().get(this.propertyName);
        }
        Object entity = this.metadataLookupStrategy != null ? (EntityDescriptor)this.metadataLookupStrategy.apply((Object)input) : (input instanceof ProfileRequestContext ? (EntityDescriptor)DEFAULT_PRC_METADATA_LOOKUP.apply((Object)((ProfileRequestContext)input)) : (input instanceof MessageContext ? (EntityDescriptor)DEFAULT_MC_METADATA_LOOKUP.apply((Object)((MessageContext)input)) : null));
        if (entity == null) {
            this.log.debug("No metadata available for relying party, no setting returned for '{}'", (Object)this.propertyName);
            return null;
        }
        String profileId = this.profileIdLookupStrategy != null ? (String)this.profileIdLookupStrategy.apply((Object)input) : (input instanceof ProfileRequestContext ? (String)DEFAULT_PRC_PROFILE_ID_LOOKUP.apply((Object)((ProfileRequestContext)input)) : (input instanceof MessageContext ? (String)DEFAULT_MC_PROFILE_ID_LOOKUP.apply((Object)((MessageContext)input)) : ""));
        Attribute attribute = this.findMatchingTag((EntityDescriptor)entity, profileId + '/' + this.propertyName);
        if (attribute != null) {
            this.log.debug("Found matching tag '{}' for property '{}'", (Object)attribute.getName(), (Object)this.propertyName);
            T result = this.translate(attribute);
            if (this.enableCaching) {
                cacheContext.getPropertyMap().put(this.propertyName, result);
            }
            return result;
        }
        for (String alias : this.propertyAliases) {
            attribute = this.findMatchingTag((EntityDescriptor)entity, alias);
            if (attribute == null) continue;
            this.log.debug("Found matching tag '{}' for property '{}'", (Object)attribute.getName(), (Object)this.propertyName);
            T result = this.translate(attribute);
            if (this.enableCaching) {
                cacheContext.getPropertyMap().put(this.propertyName, result);
            }
            return result;
        }
        this.log.debug("No applicable tag, no setting returned for '{}'", (Object)this.propertyName);
        if (this.enableCaching) {
            cacheContext.getPropertyMap().put(this.propertyName, null);
        }
        return null;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.propertyName == null) {
            throw new ComponentInitializationException("Property name cannot be null or empty");
        }
        this.propertyAliases = this.propertyAliases == null ? Collections.emptyList() : Collections2.transform(this.propertyAliases, (Function)new Function<String, String>(){

            public String apply(String input) {
                return input + (input.endsWith("/") ? AbstractMetadataDrivenConfigurationLookupStrategy.this.propertyName : '/' + AbstractMetadataDrivenConfigurationLookupStrategy.this.propertyName);
            }
        });
    }

    @Nullable
    private T translate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values == null || values.isEmpty()) {
            this.log.debug("Tag '{}' contained no values, no setting returned for '{}'", (Object)tag.getName(), (Object)this.propertyName);
            return null;
        }
        return this.doTranslate(tag);
    }

    @Nullable
    protected abstract T doTranslate(@Nonnull Attribute var1);

    @Nullable
    private Attribute findMatchingTag(@Nonnull EntityDescriptor entity, @Nonnull @NotEmpty String name) {
        Attribute tag;
        List children;
        Extensions exts = entity.getExtensions();
        if (exts != null && !(children = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty() && children.get(0) instanceof EntityAttributes && (tag = this.findMatchingTag((EntityAttributes)children.get(0), name)) != null) {
            return tag;
        }
        for (EntitiesDescriptor group = (EntitiesDescriptor)entity.getParent(); group != null; group = (EntitiesDescriptor)group.getParent()) {
            Attribute tag2;
            List children2;
            exts = group.getExtensions();
            if (exts == null || (children2 = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty() || !(children2.get(0) instanceof EntityAttributes) || (tag2 = this.findMatchingTag((EntityAttributes)children2.get(0), name)) == null) continue;
            return tag2;
        }
        return null;
    }

    @Nullable
    private Attribute findMatchingTag(@Nonnull EntityAttributes entityAttributes, @Nonnull @NotEmpty String name) {
        for (Attribute tag : entityAttributes.getAttributes()) {
            if (!Objects.equals(tag.getName(), name) || this.strictNameFormat && !Objects.equals(tag.getNameFormat(), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri")) continue;
            return tag;
        }
        return null;
    }

    public static final class CachedConfigurationContext
    extends BaseContext {
        @Nonnull
        private Map<String, Object> propertyMap = new HashMap<String, Object>();

        @Nonnull
        @Live
        Map<String, Object> getPropertyMap() {
            return this.propertyMap;
        }
    }
}

