/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollectionConfigurationLookupStrategy<T1, T2>
extends AbstractMetadataDrivenConfigurationLookupStrategy<T2> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractCollectionConfigurationLookupStrategy.class);
    @NonnullAfterInit
    private Class<T1> propertyType;

    @NonnullAfterInit
    public Class<T1> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(@Nonnull Class<T1> type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.propertyType = (Class)Constraint.isNotNull(type, (String)"Property type cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.propertyType == null) {
            throw new ComponentInitializationException("Property type cannot be null");
        }
    }

    protected T1 createInstanceFromString(@Nonnull @NotEmpty String input) throws ReflectiveOperationException {
        if (this.propertyType.isAssignableFrom(input.getClass())) {
            return this.propertyType.cast(input);
        }
        return this.propertyType.getConstructor(String.class).newInstance(input);
    }

    @Nullable
    protected String xmlObjectToString(@Nonnull XMLObject object) {
        XSAny wc;
        if (object instanceof XSString) {
            return ((XSString)object).getValue();
        }
        if (object instanceof XSURI) {
            return ((XSURI)object).getValue();
        }
        if (object instanceof XSBoolean) {
            XSBooleanValue value = ((XSBoolean)object).getValue();
            return value != null ? (value.getValue().booleanValue() ? "1" : "0") : null;
        }
        if (object instanceof XSInteger) {
            Integer value = ((XSInteger)object).getValue();
            return value != null ? value.toString() : null;
        }
        if (object instanceof XSDateTime) {
            DateTime dt = ((XSDateTime)object).getValue();
            return dt != null ? Long.toString(dt.getMillis()) : null;
        }
        if (object instanceof XSBase64Binary) {
            return ((XSBase64Binary)object).getValue();
        }
        if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            return wc.getTextContent();
        }
        this.log.error("Unsupported conversion to String from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

