/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.joda.time.DateTime;
import org.opensaml.saml.metadata.resolver.ClearableMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelyingPartyMetadataProvider
extends AbstractServiceableComponent<MetadataResolver>
implements RefreshableMetadataResolver,
ClearableMetadataResolver,
Comparable<RelyingPartyMetadataProvider> {
    private static int sortKeyValue;
    private final Logger log = LoggerFactory.getLogger(RelyingPartyMetadataProvider.class);
    @NonnullAfterInit
    private MetadataResolver resolver;
    @NonnullAfterInit
    private Integer sortKey;

    @Deprecated
    public RelyingPartyMetadataProvider(@Nonnull @ParameterName(name="child") MetadataResolver child) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"RelyingPartyMetadataProvider(MetadataResolver)", null, null);
        this.resolver = (MetadataResolver)Constraint.isNotNull((Object)child, (String)"MetadataResolver cannot be null");
    }

    public RelyingPartyMetadataProvider() {
    }

    public void setSortKey(int key) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sortKey = key;
    }

    @Nonnull
    public void setEmbeddedResolver(@Nonnull MetadataResolver theResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (MetadataResolver)Constraint.isNotNull((Object)theResolver, (String)"MetadataResolver cannot be null");
    }

    @Nonnull
    public MetadataResolver getEmbeddedResolver() {
        return this.resolver;
    }

    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.resolver.resolve((Object)criteria);
    }

    @Nullable
    public EntityDescriptor resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return (EntityDescriptor)this.resolver.resolveSingle((Object)criteria);
    }

    public boolean isRequireValidMetadata() {
        return this.resolver.isRequireValidMetadata();
    }

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver.setRequireValidMetadata(requireValidMetadata);
    }

    @Nullable
    public MetadataFilter getMetadataFilter() {
        return this.resolver.getMetadataFilter();
    }

    public void setMetadataFilter(@Nullable MetadataFilter newFilter) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver.setMetadataFilter(newFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws ComponentInitializationException {
        this.setId(this.resolver.getId());
        super.doInitialize();
        if (null == this.resolver) {
            throw new ComponentInitializationException("MetadataResolver cannot be null");
        }
        if (null == this.sortKey) {
            RelyingPartyMetadataProvider relyingPartyMetadataProvider = this;
            synchronized (relyingPartyMetadataProvider) {
                this.sortKey = ++sortKeyValue;
            }
            this.log.info("Top level Metadata Provider '{}' did not have a sort key; giving it value '{}'", (Object)this.getId(), (Object)this.sortKey);
        }
    }

    @Nonnull
    public MetadataResolver getComponent() {
        return this;
    }

    public void clear() throws ResolverException {
        if (this.resolver instanceof ClearableMetadataResolver) {
            ((ClearableMetadataResolver)this.resolver).clear();
        }
    }

    public void clear(String entityID) throws ResolverException {
        if (this.resolver instanceof ClearableMetadataResolver) {
            ((ClearableMetadataResolver)this.resolver).clear(entityID);
        }
    }

    public void refresh() throws ResolverException {
        if (this.resolver instanceof RefreshableMetadataResolver) {
            ((RefreshableMetadataResolver)this.resolver).refresh();
        }
    }

    public DateTime getLastRefresh() {
        if (this.resolver instanceof RefreshableMetadataResolver) {
            return ((RefreshableMetadataResolver)this.resolver).getLastRefresh();
        }
        return null;
    }

    public DateTime getLastUpdate() {
        if (this.resolver instanceof RefreshableMetadataResolver) {
            return ((RefreshableMetadataResolver)this.resolver).getLastUpdate();
        }
        return null;
    }

    @Override
    public int compareTo(RelyingPartyMetadataProvider other) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        int result = this.sortKey.compareTo(other.sortKey);
        if (result != 0) {
            return result;
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof RelyingPartyMetadataProvider)) {
            return false;
        }
        RelyingPartyMetadataProvider otherRp = (RelyingPartyMetadataProvider)other;
        return Objects.equal((Object)otherRp.sortKey, (Object)this.sortKey) && Objects.equal((Object)this.getId(), (Object)otherRp.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortKey, this.getId()});
    }
}

