/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile;

import com.google.common.base.Function;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.profile.ActionTestSupportAction;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SAML2ActionSupportTest
extends OpenSAMLInitBaseTestCase {
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    @Test
    public void testAddAssertionToResponse() throws ComponentInitializationException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        RequestContext springRequestContext = new RequestContextBuilder().setOutboundMessage((Object)response).setRelyingPartyProfileConfigurations(SAML2ActionTestingSupport.buildProfileConfigurations()).buildRequestContext();
        ProfileRequestContext profileRequestContext = (ProfileRequestContext)springRequestContext.getConversationScope().get("opensamlProfileRequestContext");
        ActionTestSupportAction action = new ActionTestSupportAction();
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)profileRequestContext);
        Assert.assertEquals((int)response.getAssertions().size(), (int)0, (String)"Expected zarro assertions before insert");
        Assertion assertion = SAML2ActionSupport.addAssertionToResponse((AbstractProfileAction)action, (Response)response, (IdentifierGenerationStrategy)relyingPartyCtx.getProfileConfig().getSecurityConfiguration().getIdGenerator(), (String)relyingPartyCtx.getConfiguration().getResponderId());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1, (String)"Expected but one assertion after insert");
        Assert.assertTrue((boolean)response.getAssertions().contains(assertion), (String)"Inserted assertion should be there");
        Assertion second = SAML2ActionSupport.addAssertionToResponse((AbstractProfileAction)action, (Response)response, (IdentifierGenerationStrategy)relyingPartyCtx.getProfileConfig().getSecurityConfiguration().getIdGenerator(), (String)relyingPartyCtx.getConfiguration().getResponderId());
        Assert.assertEquals((int)response.getAssertions().size(), (int)2, (String)"Expected two assertions after two inserts");
        Assert.assertTrue((boolean)response.getAssertions().contains(assertion), (String)"Inserted assertion should be there");
        Assert.assertNotSame((Object)second, (Object)assertion, (String)"Two separate assertions should have been added");
    }

    @Test
    public void testAddConditionsToAssertion() throws ComponentInitializationException {
        ActionTestSupportAction action = new ActionTestSupportAction();
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        Assert.assertNull((Object)assertion.getConditions(), (String)"No conditions on empty assertion");
        Conditions conditions = SAML2ActionSupport.addConditionsToAssertion((AbstractProfileAction)action, (Assertion)assertion);
        Assert.assertEquals((Object)assertion.getConditions(), (Object)conditions, (String)"Added conditions - should be what we got back");
        Conditions second = SAML2ActionSupport.addConditionsToAssertion((AbstractProfileAction)action, (Assertion)assertion);
        Assert.assertEquals((Object)conditions, (Object)second, (String)"Added conditions twice - should return the same value twice");
    }
}

