/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.config;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.profile.config.BasicSAMLArtifactConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.idp.saml.saml1.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrowserSSOProfileConfigurationTest {
    @Test
    public void testProfileId() {
        Assert.assertEquals((String)"http://shibboleth.net/ns/profiles/saml1/sso/browser", (String)"http://shibboleth.net/ns/profiles/saml1/sso/browser");
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertEquals((String)config.getId(), (String)"http://shibboleth.net/ns/profiles/saml1/sso/browser");
    }

    @Test
    public void testResolveAttributes() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.resolveAttributes());
        config.setResolveAttributes(false);
        Assert.assertFalse((boolean)config.resolveAttributes());
    }

    @Test
    public void testIndirectResolveAttributes() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setResolveAttributesPredicate(Predicates.alwaysFalse());
        Assert.assertFalse((boolean)config.resolveAttributes());
    }

    @Test
    public void testIncludeAttributeStatement() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertFalse((boolean)config.includeAttributeStatement());
        config.setIncludeAttributeStatement(true);
        Assert.assertTrue((boolean)config.includeAttributeStatement());
    }

    @Test
    public void testIndirectIncludeAttributeStatement() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setIncludeAttributeStatementPredicate(Predicates.alwaysTrue());
        Assert.assertTrue((boolean)config.includeAttributeStatement());
    }

    @Test
    public void testArtifactConfiguration() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertNull((Object)config.getArtifactConfiguration());
        BasicSAMLArtifactConfiguration artifactConfiguration = new BasicSAMLArtifactConfiguration();
        config.setArtifactConfiguration((SAMLArtifactConfiguration)artifactConfiguration);
        Assert.assertSame((Object)config.getArtifactConfiguration(), (Object)artifactConfiguration);
    }

    @Test
    public void testIndirectArtifactConfiguration() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        BasicSAMLArtifactConfiguration artifactConfiguration = new BasicSAMLArtifactConfiguration();
        config.setArtifactConfigurationLookupStrategy(FunctionSupport.constant((Object)artifactConfiguration));
        Assert.assertSame((Object)config.getArtifactConfiguration(), (Object)artifactConfiguration);
    }

    @Test
    public void testDefaultAuthenticationMethods() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getDefaultAuthenticationMethods().isEmpty());
        ArrayList<AuthenticationMethodPrincipal> principals = new ArrayList<AuthenticationMethodPrincipal>();
        principals.add(new AuthenticationMethodPrincipal("foo"));
        principals.add(new AuthenticationMethodPrincipal("bar"));
        config.setDefaultAuthenticationMethods(principals);
        Assert.assertEquals((Collection)config.getDefaultAuthenticationMethods(), principals);
    }

    @Test
    public void testIndirectDefaultAuthenticationMethods() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        ArrayList<AuthenticationMethodPrincipal> principals = new ArrayList<AuthenticationMethodPrincipal>();
        principals.add(new AuthenticationMethodPrincipal("foo"));
        principals.add(new AuthenticationMethodPrincipal("bar"));
        config.setDefaultAuthenticationMethodsLookupStrategy(FunctionSupport.constant(principals));
        Assert.assertEquals((Collection)config.getDefaultAuthenticationMethods(), principals);
    }

    @Test
    public void testAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getAuthenticationFlows().isEmpty());
        HashSet<String> flows = new HashSet<String>();
        flows.add("foo");
        flows.add("bar");
        config.setAuthenticationFlows(flows);
        Assert.assertEquals((Set)config.getAuthenticationFlows(), flows);
    }

    @Test
    public void testIndirectAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        HashSet<String> flows = new HashSet<String>();
        flows.add("foo");
        flows.add("bar");
        config.setAuthenticationFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Set)config.getAuthenticationFlows(), flows);
    }

    @Test
    public void testPostAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getPostAuthenticationFlows().isEmpty());
        ArrayList<String> flows = new ArrayList<String>();
        flows.add("foo");
        flows.add("bar");
        config.setPostAuthenticationFlows(flows);
        Assert.assertEquals((Collection)config.getPostAuthenticationFlows(), flows);
    }

    @Test
    public void testIndirectPostAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        ArrayList<String> flows = new ArrayList<String>();
        flows.add("foo");
        flows.add("bar");
        config.setPostAuthenticationFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Collection)config.getPostAuthenticationFlows(), flows);
    }

    @Test
    public void testNameIDFormatPrecedence() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getNameIDFormatPrecedence().isEmpty());
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("foo");
        formats.add("bar");
        config.setNameIDFormatPrecedence(formats);
        Assert.assertEquals((Collection)config.getNameIDFormatPrecedence(), formats);
    }

    @Test
    public void testIndirectNameIDFormatPrecedence() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("foo");
        formats.add("bar");
        config.setNameIDFormatPrecedenceLookupStrategy(FunctionSupport.constant(formats));
        Assert.assertEquals((Collection)config.getNameIDFormatPrecedence(), formats);
    }
}

