/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.shibboleth.idp.saml.profile.config.AbstractSAMLProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractSAMLProfileConfigurationTest {
    @Test
    public void testSignAssertionsCriteria() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        Assert.assertNotNull((Object)config.getSignAssertions());
        config.setSignAssertions(Predicates.alwaysFalse());
        Assert.assertSame((Object)config.getSignAssertions(), (Object)Predicates.alwaysFalse());
        try {
            config.setSignAssertions(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testSignResponsesCriteria() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        Assert.assertNotNull((Object)config.getSignResponses());
        config.setSignResponses(Predicates.alwaysFalse());
        Assert.assertSame((Object)config.getSignResponses(), (Object)Predicates.alwaysFalse());
        try {
            config.setSignResponses(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testSignRequestsCriteria() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        Assert.assertNotNull((Object)config.getSignRequests());
        config.setSignRequests(Predicates.alwaysFalse());
        Assert.assertSame((Object)config.getSignRequests(), (Object)Predicates.alwaysFalse());
        try {
            config.setSignRequests(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testAssertionLifetime() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        Assert.assertTrue((config.getAssertionLifetime() > 0L ? 1 : 0) != 0);
        config.setAssertionLifetime(100L);
        Assert.assertEquals((long)config.getAssertionLifetime(), (long)100L);
        try {
            config.setAssertionLifetime(0L);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            config.setAssertionLifetime(-100L);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testIndirectAssertionLifetime() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        config.setAssertionLifetimeLookupStrategy(FunctionSupport.constant((Object)500L));
        Assert.assertEquals((long)config.getAssertionLifetime(), (long)500L);
        config.setAssertionLifetimeLookupStrategy(FunctionSupport.constant(null));
        Assert.assertEquals((long)config.getAssertionLifetime(), (long)300000L);
    }

    @Test
    public void testIncludeNotBefore() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        Assert.assertTrue((boolean)config.includeConditionsNotBefore());
        config.setIncludeConditionsNotBefore(false);
        Assert.assertFalse((boolean)config.includeConditionsNotBefore());
    }

    @Test
    public void testIndirectIncludeNotBefore() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        config.setIncludeConditionsNotBeforePredicate(Predicates.alwaysFalse());
        Assert.assertFalse((boolean)config.includeConditionsNotBefore());
    }

    @Test
    public void testAdditionalAudiencesForAssertion() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        Assert.assertNotNull((Object)config.getAdditionalAudiencesForAssertion());
        Assert.assertTrue((boolean)config.getAdditionalAudiencesForAssertion().isEmpty());
        config.setAdditionalAudienceForAssertion(Arrays.asList("", null, " foo"));
        Set audiences = config.getAdditionalAudiencesForAssertion();
        Assert.assertNotNull((Object)audiences);
        Assert.assertEquals((int)audiences.size(), (int)1);
        Assert.assertTrue((boolean)audiences.contains("foo"));
        try {
            audiences.add("bar");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        config.setAdditionalAudienceForAssertion(Collections.emptyList());
        Assert.assertNotNull((Object)config.getAdditionalAudiencesForAssertion());
        Assert.assertTrue((boolean)config.getAdditionalAudiencesForAssertion().isEmpty());
    }

    @Test
    public void testIndirectAudiencesForAssertion() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        HashSet<String> audiences = new HashSet<String>();
        audiences.add("foo");
        audiences.add("bar");
        config.setAdditionalAudiencesForAssertion(audiences);
        Assert.assertEquals((Set)config.getAdditionalAudiencesForAssertion(), audiences);
    }

    private static class MockSAMLProfileConfiguration
    extends AbstractSAMLProfileConfiguration {
        public MockSAMLProfileConfiguration() {
            super("mock");
        }
    }
}

