/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding;

import com.google.common.base.Strings;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.SAMLEncoderSupport;
import net.shibboleth.idp.saml.xmlobject.ScopedValue;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSAnyImpl;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.NameID;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SAMLEncoderSupportTest
extends OpenSAMLInitBaseTestCase {
    private static final String QNAME_LOCALPART = "myQName";
    private static final QName QNAME = new QName("myQName");
    private static final String STRING_VALUE = "TestValue";
    private static final String STRING_SCOPE = "TestScope";
    private static final String SCOPE_ATTRIBUTE_NAME = "Scpe";
    private static final String DELIMITER = "@";
    private static final IdPAttribute ATTR = new IdPAttribute("attr");
    private static final byte[] BYTE_ARRAY_VALUE = new byte[]{1, 2, 3, 4, 5};
    private static final ScopedStringAttributeValue SCOPEDVAL = new ScopedStringAttributeValue("TestValue", "TestScope");

    @Test
    public void encodeStringValue() {
        try {
            SAMLEncoderSupport.encodeStringValue(null, (QName)QNAME, (String)STRING_VALUE, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLEncoderSupport.encodeStringValue((IdPAttribute)ATTR, null, (String)STRING_VALUE, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        Assert.assertNull((Object)SAMLEncoderSupport.encodeStringValue((IdPAttribute)ATTR, (QName)QNAME, (String)"", (boolean)true));
        Assert.assertNull((Object)SAMLEncoderSupport.encodeStringValue((IdPAttribute)ATTR, (QName)QNAME, null, (boolean)true));
        XMLObject obj = SAMLEncoderSupport.encodeStringValue((IdPAttribute)ATTR, (QName)QNAME, (String)STRING_VALUE, (boolean)true);
        Assert.assertEquals((String)obj.getElementQName().getLocalPart(), (String)QNAME_LOCALPART);
        Assert.assertTrue((boolean)(obj instanceof XSString));
        XSString str = (XSString)obj;
        Assert.assertEquals((String)str.getValue(), (String)STRING_VALUE);
    }

    @Test
    public void encodeByteArrayValue() {
        try {
            SAMLEncoderSupport.encodeByteArrayValue(null, (QName)QNAME, (byte[])BYTE_ARRAY_VALUE, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLEncoderSupport.encodeByteArrayValue((IdPAttribute)ATTR, null, (byte[])BYTE_ARRAY_VALUE, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        Assert.assertNull((Object)SAMLEncoderSupport.encodeByteArrayValue((IdPAttribute)ATTR, (QName)QNAME, null, (boolean)true));
        Assert.assertNull((Object)SAMLEncoderSupport.encodeByteArrayValue((IdPAttribute)ATTR, (QName)QNAME, (byte[])new byte[0], (boolean)true));
        XMLObject obj = SAMLEncoderSupport.encodeByteArrayValue((IdPAttribute)ATTR, (QName)QNAME, (byte[])BYTE_ARRAY_VALUE, (boolean)true);
        Assert.assertEquals((String)obj.getElementQName().getLocalPart(), (String)QNAME_LOCALPART);
        Assert.assertTrue((boolean)(obj instanceof XSBase64Binary));
        XSBase64Binary str = (XSBase64Binary)obj;
        Assert.assertEquals((byte[])Base64Support.decode((String)str.getValue()), (byte[])BYTE_ARRAY_VALUE);
    }

    @Test
    public void encodeXmlObjectValue() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameID.DEFAULT_ELEMENT_NAME);
        NameID objToEncode = (NameID)builder.buildObject();
        objToEncode.setValue(STRING_VALUE);
        try {
            SAMLEncoderSupport.encodeXMLObjectValue(null, (QName)QNAME, (XMLObject)objToEncode);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLEncoderSupport.encodeXMLObjectValue((IdPAttribute)ATTR, null, (XMLObject)objToEncode);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        Assert.assertNull((Object)SAMLEncoderSupport.encodeXMLObjectValue((IdPAttribute)ATTR, (QName)QNAME, null));
        XMLObject obj = SAMLEncoderSupport.encodeXMLObjectValue((IdPAttribute)ATTR, (QName)QNAME, (XMLObject)objToEncode);
        Assert.assertEquals((String)obj.getElementQName().getLocalPart(), (String)QNAME_LOCALPART);
        Assert.assertTrue((boolean)(obj instanceof XSAny));
        XSAny any = (XSAny)obj;
        List what = any.getUnknownXMLObjects();
        Assert.assertEquals((int)what.size(), (int)1);
        Assert.assertTrue((boolean)(what.get(0) instanceof NameID));
        NameID other = (NameID)what.get(0);
        Assert.assertEquals((String)other.getValue(), (String)STRING_VALUE);
    }

    @Test
    public void encodeScopedStringValueAttribute() {
        XMLObjectProviderRegistrySupport.registerObjectProvider((QName)ScopedValue.TYPE_NAME, (XMLObjectBuilder)new ScopedValueBuilder(), (Marshaller)new ScopedValueMarshaller(), (Unmarshaller)new ScopedValueUnmarshaller());
        try {
            SAMLEncoderSupport.encodeScopedStringValueAttribute(null, (QName)QNAME, (ScopedStringAttributeValue)SCOPEDVAL, (String)SCOPE_ATTRIBUTE_NAME, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLEncoderSupport.encodeScopedStringValueAttribute((IdPAttribute)ATTR, null, (ScopedStringAttributeValue)SCOPEDVAL, (String)SCOPE_ATTRIBUTE_NAME, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLEncoderSupport.encodeScopedStringValueAttribute((IdPAttribute)ATTR, (QName)QNAME, (ScopedStringAttributeValue)SCOPEDVAL, null, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        Assert.assertNull((Object)SAMLEncoderSupport.encodeScopedStringValueAttribute((IdPAttribute)ATTR, (QName)QNAME, null, (String)SCOPE_ATTRIBUTE_NAME, (boolean)true));
        XMLObject obj = SAMLEncoderSupport.encodeScopedStringValueAttribute((IdPAttribute)ATTR, (QName)QNAME, (ScopedStringAttributeValue)SCOPEDVAL, (String)SCOPE_ATTRIBUTE_NAME, (boolean)true);
        Assert.assertEquals((String)obj.getElementQName().getLocalPart(), (String)QNAME_LOCALPART);
        Assert.assertTrue((boolean)(obj instanceof ScopedValue));
        ScopedValue sv = (ScopedValue)obj;
        Assert.assertEquals((String)sv.getValue(), (String)STRING_VALUE);
        Assert.assertEquals((String)sv.getScope(), (String)STRING_SCOPE);
    }

    @Test
    public void encodeScopedStringValueInline() {
        try {
            SAMLEncoderSupport.encodeScopedStringValueInline(null, (QName)QNAME, (ScopedStringAttributeValue)SCOPEDVAL, (String)DELIMITER, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLEncoderSupport.encodeScopedStringValueInline((IdPAttribute)ATTR, null, (ScopedStringAttributeValue)SCOPEDVAL, (String)DELIMITER, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            SAMLEncoderSupport.encodeScopedStringValueInline((IdPAttribute)ATTR, (QName)QNAME, (ScopedStringAttributeValue)SCOPEDVAL, null, (boolean)true);
            Assert.fail((String)"Missed contraint");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        Assert.assertNull((Object)SAMLEncoderSupport.encodeScopedStringValueInline((IdPAttribute)ATTR, (QName)QNAME, null, (String)DELIMITER, (boolean)true));
        XMLObject obj = SAMLEncoderSupport.encodeScopedStringValueInline((IdPAttribute)ATTR, (QName)QNAME, (ScopedStringAttributeValue)SCOPEDVAL, (String)DELIMITER, (boolean)true);
        Assert.assertEquals((String)obj.getElementQName().getLocalPart(), (String)QNAME_LOCALPART);
        Assert.assertTrue((boolean)(obj instanceof XSString));
        XSString str = (XSString)obj;
        Assert.assertEquals((String)str.getValue(), (String)"TestValue@TestScope");
    }

    private class ScopedValueUnmarshaller
    extends AbstractXMLObjectUnmarshaller {
        private ScopedValueUnmarshaller() {
        }

        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            ScopedValue sv = (ScopedValue)xmlObject;
            if (Strings.isNullOrEmpty((String)sv.getScopeAttributeName())) {
                sv.setScopeAttributeName(attribute.getName());
                sv.setScope(attribute.getValue());
            }
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
            ScopedValue sv = (ScopedValue)xmlObject;
            sv.setValue(elementContent);
        }
    }

    private class ScopedValueMarshaller
    extends AbstractXMLObjectMarshaller {
        private ScopedValueMarshaller() {
        }

        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            ScopedValue scopedValue = (ScopedValue)xmlObject;
            if (null != scopedValue.getScopeAttributeName()) {
                domElement.setAttributeNS(null, scopedValue.getScopeAttributeName(), scopedValue.getScope());
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
            ScopedValue scopedValue = (ScopedValue)xmlObject;
            ElementSupport.appendTextContent((Element)domElement, (String)scopedValue.getValue());
        }
    }

    private class ScopedValueImpl
    extends XSAnyImpl
    implements ScopedValue {
        private String scope;
        private String scopeAttributeName;

        protected ScopedValueImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
            super(namespaceURI, elementLocalName, namespacePrefix);
        }

        public String getScope() {
            return this.scope;
        }

        public String getScopeAttributeName() {
            return this.scopeAttributeName;
        }

        public void setScope(String newScope) {
            this.scope = this.prepareForAssignment(this.scope, newScope);
            if (this.scope != null && this.scopeAttributeName != null) {
                this.getUnknownAttributes().put(new QName(this.scopeAttributeName), this.scope);
            }
        }

        public void setScopeAttributeName(String newScopeAttributeName) {
            if (this.scopeAttributeName != null) {
                QName oldName = new QName(this.scopeAttributeName);
                if (this.getUnknownAttributes().containsKey((Object)oldName)) {
                    this.getUnknownAttributes().remove((Object)oldName);
                }
            }
            this.scopeAttributeName = this.prepareForAssignment(this.scopeAttributeName, newScopeAttributeName);
            if (this.scope != null) {
                this.getUnknownAttributes().put(new QName(this.scopeAttributeName), this.scope);
            }
        }

        public String getValue() {
            return this.getTextContent();
        }

        public void setValue(String newValue) {
            this.setTextContent(newValue);
        }
    }

    private class ScopedValueBuilder
    extends AbstractXMLObjectBuilder<ScopedValue> {
        private ScopedValueBuilder() {
        }

        public ScopedValue buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new ScopedValueImpl(namespaceURI, localName, namespacePrefix);
        }
    }
}

