/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.AbstractSAML2AttributeEncoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AbstractSAML2AttributeEncoderTest
extends OpenSAMLInitBaseTestCase {
    private XMLObjectBuilder<XSString> theBuilder;
    private QName theQName = new QName("LocalQNAME");
    private final String MY_NAME = "myName";
    private final String MY_NAMESPACE = "myNameSpace";
    private final String ATTRIBUTE_ID = "attrID";
    private final String ATTRIBUTE_VALUE_1 = "attrValOne";
    private final String ATTRIBUTE_VALUE_2 = "attrValueTwo";
    private final String FRIENDLY_NAME = "friendly";

    @BeforeClass
    public void initTest() throws ComponentInitializationException {
        this.theBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSString.TYPE_NAME);
    }

    @Test
    public void abstractSAML2AttributeEncoder() throws ComponentInitializationException, AttributeEncodingException {
        mockEncoder encoder = new mockEncoder();
        encoder.setName("myName");
        encoder.setNameFormat("myNameSpace");
        encoder.setFriendlyName("friendly");
        encoder.initialize();
        Assert.assertEquals((String)encoder.getProtocol(), (String)"urn:oasis:names:tc:SAML:2.0:protocol");
        IdPAttribute attr = new IdPAttribute("attrID");
        attr.setValues(Arrays.asList(new StringAttributeValue("attrValOne"), new StringAttributeValue("attrValueTwo")));
        SAMLObject obj = encoder.encode(attr);
        Assert.assertTrue((boolean)(obj instanceof Attribute));
        List result = ((Attribute)obj).getAttributeValues();
        Assert.assertEquals((int)result.size(), (int)2);
        HashSet<String> resultSet = new HashSet<String>(2);
        for (XMLObject o : result) {
            Assert.assertTrue((boolean)(o instanceof XSString));
            resultSet.add(((XSString)o).getValue());
        }
        Assert.assertTrue((boolean)resultSet.contains("attrValOne"));
        Assert.assertTrue((boolean)resultSet.contains("attrValueTwo"));
    }

    @Test
    public void friendlyName() throws ComponentInitializationException {
        mockEncoder encoder = new mockEncoder();
        Assert.assertNull((Object)encoder.getFriendlyName());
        encoder.setName("myName");
        encoder.setNameFormat("myNameSpace");
        encoder.initialize();
        encoder = new mockEncoder();
        Assert.assertNull((Object)encoder.getFriendlyName());
        encoder.setName("myName");
        encoder.setFriendlyName("friendly");
        encoder.setNameFormat("myNameSpace");
        Assert.assertEquals((String)encoder.getFriendlyName(), (String)"friendly");
        encoder.initialize();
        Assert.assertEquals((String)encoder.getFriendlyName(), (String)"friendly");
        try {
            encoder.setFriendlyName("friendly");
            Assert.fail();
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
    }

    protected class mockEncoder
    extends AbstractSAML2AttributeEncoder {
        protected mockEncoder() {
        }

        protected boolean canEncodeValue(IdPAttribute attribute, IdPAttributeValue value) {
            return !(value instanceof ByteAttributeValue);
        }

        protected XMLObject encodeValue(IdPAttribute attribute, IdPAttributeValue value) throws AttributeEncodingException {
            if (!(value instanceof StringAttributeValue)) {
                return null;
            }
            XSString result = (XSString)AbstractSAML2AttributeEncoderTest.this.theBuilder.buildObject(AbstractSAML2AttributeEncoderTest.this.theQName);
            result.setValue((String)value.getValue());
            return result;
        }
    }
}

