/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.mapping;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.saml.attribute.mapping.AttributeMapper;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLAttributeDesignatorMapper<OutType extends IdPAttribute>
extends AbstractIdentifiableInitializableComponent
implements AttributeMapper<AttributeDesignator, OutType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLAttributeDesignatorMapper.class);
    @Nonnull
    @NonnullElements
    private List<String> attributeIds = Collections.emptyList();
    @Nullable
    private String attributeNamespace;
    @NonnullAfterInit
    private String theSAMLName;
    @Nullable
    private String logPrefix;

    public void setAttributeIds(@Nullable @NullableElements List<String> theIds) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (null == theIds) {
            return;
        }
        this.attributeIds = ImmutableList.copyOf((Collection)StringSupport.normalizeStringCollection(theIds));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<String> getAttributeIds() {
        return this.attributeIds;
    }

    public void setSAMLName(@Nullable String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.theSAMLName = StringSupport.trimOrNull((String)name);
    }

    @NonnullAfterInit
    public String getSAMLName() {
        return this.theSAMLName;
    }

    public void setAttributeNamespace(@Nullable String ns) {
        this.attributeNamespace = StringSupport.trimOrNull((String)ns);
    }

    @Nullable
    public String getAttributeNamespace() {
        return this.attributeNamespace;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.theSAMLName) {
            throw new ComponentInitializationException(this.getLogPrefix() + " SAML name not present");
        }
        if (this.attributeIds.isEmpty()) {
            throw new ComponentInitializationException(this.getLogPrefix() + " At least one attribute Id should be provided");
        }
        this.logPrefix = null;
    }

    protected boolean matches(@Nonnull @NotEmpty String otherSAMLName, @Nullable String otherSAMLNamespace) {
        if (!otherSAMLName.equals(this.theSAMLName)) {
            this.log.debug("{} SAML attribute name {} does not match {}", new Object[]{this.getLogPrefix(), otherSAMLName, this.getId()});
            return false;
        }
        if (!Objects.equals(otherSAMLNamespace, this.getAttributeNamespace())) {
            this.log.debug("{} SAML attribute namespace {} does not match {}", new Object[]{this.getLogPrefix(), otherSAMLNamespace, this.getAttributeNamespace()});
            return false;
        }
        return true;
    }

    protected boolean attributeMatches(@Nonnull AttributeDesignator designator) {
        return this.matches(designator.getAttributeName(), designator.getAttributeNamespace());
    }

    @Override
    @Nonnull
    @NonnullElements
    public Map<String, OutType> mapAttribute(@Nonnull AttributeDesignator prototype) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (!this.attributeMatches(prototype)) {
            return Collections.emptyMap();
        }
        HashMap<String, OutType> output = new HashMap<String, OutType>();
        this.log.debug("{} attribute id {} and aliases {} will be created", new Object[]{this.getLogPrefix(), this.getId(), this.getAttributeIds()});
        OutType out = this.newAttribute(prototype, this.getId());
        for (String id : this.attributeIds) {
            out = this.newAttribute(prototype, this.getId());
            output.put(id, out);
        }
        return output;
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder();
            builder.append("Attribute Mapper '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractSAMLAttributeDesignatorMapper) {
            AbstractSAMLAttributeDesignatorMapper other = (AbstractSAMLAttributeDesignatorMapper)obj;
            return this.matches(other.getSAMLName(), other.getAttributeNamespace()) && Objects.equals(this.getAttributeIds(), other.getAttributeIds());
        }
        return false;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.attributeNamespace, this.theSAMLName, this.attributeIds});
    }

    @Nonnull
    protected abstract OutType newAttribute(@Nonnull AttributeDesignator var1, @Nonnull @NotEmpty String var2);
}

