/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate;

public class LegacySigningRequirementPredicate
extends NoIntegrityMessageChannelPredicate {
    private final SigningRequirementSetting settingToApply;

    public LegacySigningRequirementPredicate(@Nonnull @NotEmpty String setting) {
        Constraint.isNotNull((Object)setting, (String)"Signing requirement setting cannot be null");
        if ("always".equals(setting)) {
            this.settingToApply = SigningRequirementSetting.ALWAYS;
        } else if ("conditional".equals(setting)) {
            this.settingToApply = SigningRequirementSetting.CONDITIONAL;
        } else if ("never".equals(setting)) {
            this.settingToApply = SigningRequirementSetting.NEVER;
        } else {
            throw new IllegalArgumentException("Signing requirement setting not one of the supported values");
        }
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        switch (this.settingToApply) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case CONDITIONAL: {
                return super.apply(input);
            }
        }
        throw new IllegalArgumentException("Signing requirement setting not one of the supported values");
    }

    private static enum SigningRequirementSetting {
        ALWAYS,
        CONDITIONAL,
        NEVER;

    }
}

