/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.mapping;

import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.saml.attribute.encoding.AttributeMapperProcessor;
import net.shibboleth.idp.saml.attribute.mapping.AbstractSAMLAttributeMapper;
import net.shibboleth.idp.saml.attribute.mapping.AttributeMapper;
import net.shibboleth.idp.saml.attribute.mapping.AttributesMapper;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLAttributesMapper<InType extends Attribute, OutType extends IdPAttribute>
extends AbstractIdentifiableInitializableComponent
implements AttributesMapper<InType, OutType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLAttributesMapper.class);
    @Nonnull
    @NonnullElements
    private Collection<AttributeMapper<InType, OutType>> mappers = Collections.EMPTY_LIST;
    @Nullable
    private String logPrefix;

    public AbstractSAMLAttributesMapper() {
    }

    public AbstractSAMLAttributesMapper(@Nonnull AttributeResolver resolver, @Nonnull @NotEmpty String id, @Nonnull Supplier<AbstractSAMLAttributeMapper<InType, OutType>> mapperFactory) {
        this.setId(id);
        HashMultimap theMappers = HashMultimap.create();
        for (AttributeDefinition attributeDefinition : resolver.getAttributeDefinitions().values()) {
            for (AttributeEncoder encode : attributeDefinition.getAttributeEncoders()) {
                if (!(encode instanceof AttributeMapperProcessor)) continue;
                AttributeMapperProcessor factory = (AttributeMapperProcessor)encode;
                AbstractSAMLAttributeMapper mapper = (AbstractSAMLAttributeMapper)mapperFactory.get();
                factory.populateAttributeMapper(mapper);
                theMappers.put((Object)mapper, (Object)attributeDefinition.getId());
            }
        }
        this.mappers = new ArrayList<AttributeMapper<InType, OutType>>(theMappers.values().size());
        for (Map.Entry entry : theMappers.asMap().entrySet()) {
            AbstractSAMLAttributeMapper mapper = (AbstractSAMLAttributeMapper)entry.getKey();
            mapper.setAttributeIds(new ArrayList<String>((Collection)entry.getValue()));
            this.mappers.add(mapper);
        }
    }

    @Nonnull
    @NonnullElements
    public Collection<AttributeMapper<InType, OutType>> getMappers() {
        return this.mappers;
    }

    public void setMappers(@Nonnull Collection<AttributeMapper<InType, OutType>> theMappers) {
        this.mappers = (Collection)Constraint.isNotNull(theMappers, (String)"mappers list must be non null");
    }

    @Override
    @Nonnull
    @NonnullElements
    public Multimap<String, OutType> mapAttributes(@Nonnull @NonnullElements List<InType> prototypes) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (Attribute prototype : prototypes) {
            for (AttributeMapper<InType, OutType> mapper : this.mappers) {
                Map<String, OutType> mappedAttributes = mapper.mapAttribute(prototype);
                this.log.debug("{} SAML attribute '{}' mapped to {} attributes by mapper '{}'", new Object[]{this.getLogPrefix(), prototype.getName(), mappedAttributes.size(), mapper.getId()});
                for (Map.Entry<String, OutType> entry : mappedAttributes.entrySet()) {
                    result.put((Object)entry.getKey(), entry.getValue());
                }
            }
        }
        return result;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
        for (AttributeMapper<InType, OutType> mapper : this.mappers) {
            ComponentSupport.initialize(mapper);
        }
    }

    @Nonnull
    @NotEmpty
    private String getLogPrefix() {
        String s = this.logPrefix;
        if (null == s) {
            this.logPrefix = s = "Attribute Mappers : '" + this.getId() + "':";
        }
        return s;
    }
}

