/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.HttpClientFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.AbstractReloadingMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.FileBackedHTTPMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.FilesystemMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.HTTPMetadataProviderParser;
import net.shibboleth.idp.profile.spring.resource.impl.ClasspathResourceParser;
import net.shibboleth.idp.profile.spring.resource.impl.ResourceNamespaceHandler;
import net.shibboleth.idp.profile.spring.resource.impl.SVNResourceParser;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.saml.metadata.resolver.impl.AbstractBatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FileBackedHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceBackedMetadataProviderParser
extends AbstractReloadingMetadataProviderParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "ResourceBackedMetadataProvider");
    @Nonnull
    public static final QName RESOURCES_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "MetadataResource");
    @Nonnull
    public static final QName RESOURCE_REF = new QName("resourceRef");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ResourceBackedMetadataProviderParser.class);

    protected Class<? extends AbstractBatchMetadataResolver> getNativeBeanClass(Element element) {
        List resources = ElementSupport.getChildElements((Node)element, (QName)RESOURCES_NAME);
        if (null == resources || resources.isEmpty()) {
            if (AttributeSupport.hasAttribute((Element)element, (QName)RESOURCE_REF)) {
                return ResourceBackedMetadataResolver.class;
            }
            throw new BeanCreationException("No <Resource> specified for ResourceBackedMetadataProvider");
        }
        QName qName = DOMTypeSupport.getXSIType((Element)((Element)resources.get(0)));
        if (null == qName) {
            this.log.error("No type specified for a <Resource> within a ResourceBackedMetadataProvider");
            throw new BeanCreationException("No type specified for a <Resource> within a ResourceBackedMetadataProvider");
        }
        this.log.debug("Comparing type '{}' against known Resources", (Object)qName.getLocalPart());
        if (ClasspathResourceParser.ELEMENT_NAME.equals(qName)) {
            return ResourceBackedMetadataResolver.class;
        }
        if (SVNResourceParser.ELEMENT_NAME.equals(qName)) {
            return ResourceBackedMetadataResolver.class;
        }
        if (ResourceNamespaceHandler.HTTP_ELEMENT_NAME.equals(qName)) {
            return HTTPMetadataResolver.class;
        }
        if (ResourceNamespaceHandler.FILE_HTTP_ELEMENT_NAME.equals(qName)) {
            return FileBackedHTTPMetadataResolver.class;
        }
        if (ResourceNamespaceHandler.FILESYSTEM_ELEMENT_NAME.equals(qName)) {
            return FilesystemMetadataResolver.class;
        }
        this.log.error("ResourceBackedMetadataProvider : Unrecognised resource type: {} ", (Object)qName.getLocalPart());
        throw new BeanCreationException("ResourceBackedMetadataProvider : Unrecognised resource type: " + qName.getLocalPart());
    }

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "maxCacheDuration")) {
            this.log.error("{}: maxCacheDuration is not supported", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("maxCacheDuration is not supported", new Location(parserContext.getReaderContext().getResource())));
        }
        List resources = ElementSupport.getChildElements((Node)element, (QName)RESOURCES_NAME);
        if (resources.isEmpty()) {
            this.parseResource(StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)element, (QName)RESOURCE_REF)), parserContext, builder);
            return;
        }
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)"Resource", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"resourceRef property");
        if (resources.size() != 1) {
            this.log.error("{}: Only one Resource may be supplied to a ResourceBackedMetadataProvider", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("Only one Resource may be supplied to a ResourceBackedMetadataProvider", new Location(parserContext.getReaderContext().getResource())));
        }
        ResourceNamespaceHandler.noFilters((Element)resources.get(0), parserContext.getReaderContext());
        QName qName = DOMTypeSupport.getXSIType((Element)((Element)resources.get(0)));
        this.log.debug("Dispatching based on type '{}'", (Object)qName.getLocalPart());
        if (ClasspathResourceParser.ELEMENT_NAME.equals(qName)) {
            this.parseResource((Element)resources.get(0), parserContext, builder);
        } else if (SVNResourceParser.ELEMENT_NAME.equals(qName)) {
            this.parseResource((Element)resources.get(0), parserContext, builder);
        } else if (ResourceNamespaceHandler.HTTP_ELEMENT_NAME.equals(qName)) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)ResourceNamespaceHandler.HTTP_ELEMENT_NAME.toString(), (String)parserContext.getReaderContext().getResource().getDescription(), (String)HTTPMetadataProviderParser.ELEMENT_NAME.toString());
            this.parseHTTPResource((Element)resources.get(0), parserContext, builder);
        } else if (ResourceNamespaceHandler.FILE_HTTP_ELEMENT_NAME.equals(qName)) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)ResourceNamespaceHandler.FILE_HTTP_ELEMENT_NAME.toString(), (String)parserContext.getReaderContext().getResource().getDescription(), (String)FileBackedHTTPMetadataProviderParser.ELEMENT_NAME.toString());
            this.parseFileBackedHTTPResource((Element)resources.get(0), parserContext, builder);
        } else if (ResourceNamespaceHandler.FILESYSTEM_ELEMENT_NAME.equals(qName)) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)ResourceNamespaceHandler.FILESYSTEM_ELEMENT_NAME.toString(), (String)parserContext.getReaderContext().getResource().getDescription(), (String)FilesystemMetadataProviderParser.ELEMENT_NAME.toString());
            this.parseFilesystemResource((Element)resources.get(0), parserContext, builder);
        }
    }

    private void parseResource(@Nullable String beanReference, ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        if (null == beanReference) {
            this.log.error("{} must not be empty", (Object)RESOURCE_REF.getLocalPart());
            throw new BeanDefinitionParsingException(new Problem("Empty bean reference for a ResourceBackedMetadataProvider", new Location(parserContext.getReaderContext().getResource())));
        }
        BeanDefinitionBuilder resourceConverter = BeanDefinitionBuilder.genericBeanDefinition(ResourceHelper.class);
        resourceConverter.setLazyInit(true);
        resourceConverter.setFactoryMethod("of");
        resourceConverter.addConstructorArgReference(beanReference);
        builder.addConstructorArgValue((Object)resourceConverter.getBeanDefinition());
    }

    private void parseResource(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder resourceConverter = BeanDefinitionBuilder.genericBeanDefinition(ResourceHelper.class);
        resourceConverter.setLazyInit(true);
        resourceConverter.setFactoryMethod("of");
        resourceConverter.addConstructorArgValue((Object)parserContext.getDelegate().parseCustomElement(element));
        builder.addConstructorArgValue((Object)resourceConverter.getBeanDefinition());
    }

    private void parseHTTPResource(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder clientBuilder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
        clientBuilder.setLazyInit(true);
        builder.addConstructorArgValue((Object)clientBuilder.getBeanDefinition());
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "url")));
    }

    private void parseFileBackedHTTPResource(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.parseHTTPResource(element, parserContext, builder);
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "file")));
    }

    private void parseFilesystemResource(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "file")));
    }
}

