/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.AbstractDynamicMetadataProviderParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.persist.FilesystemLoadSaveManager;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DefaultLocalDynamicSourceKeyGenerator;
import org.opensaml.saml.metadata.resolver.impl.LocalDynamicMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class LocalDynamicMetadataProviderParser
extends AbstractDynamicMetadataProviderParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "LocalDynamicMetadataProvider");
    private Logger log = LoggerFactory.getLogger(LocalDynamicMetadataProviderParser.class);

    @Override
    protected Class<? extends MetadataResolver> getNativeBeanClass(Element element) {
        return LocalDynamicMetadataResolver.class;
    }

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        String sourceKeyGeneratorRefOrBean = null;
        if (element.hasAttributeNS(null, "sourceKeyGeneratorRef")) {
            sourceKeyGeneratorRefOrBean = StringSupport.trimOrNull((String)element.getAttributeNS(null, "sourceKeyGeneratorRef"));
        }
        String sourceManagerRefOrBean = null;
        if (element.hasAttributeNS(null, "sourceManagerRef")) {
            sourceManagerRefOrBean = StringSupport.trimOrNull((String)element.getAttributeNS(null, "sourceManagerRef"));
            if (element.hasAttributeNS(null, "sourceDirectory")) {
                this.log.warn("Presence of sourceManagerRef will override sourceDirectory");
            }
        } else if (element.hasAttributeNS(null, "sourceDirectory")) {
            BeanDefinitionBuilder sourceManagerBuilder = BeanDefinitionBuilder.genericBeanDefinition(FilesystemLoadSaveManager.class);
            sourceManagerBuilder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "sourceDirectory")));
            sourceManagerBuilder.addConstructorArgValue((Object)Boolean.TRUE);
            sourceManagerRefOrBean = sourceManagerBuilder.getBeanDefinition();
            if (sourceKeyGeneratorRefOrBean == null) {
                sourceKeyGeneratorRefOrBean = new DefaultLocalDynamicSourceKeyGenerator(null, ".xml", null);
            }
        } else {
            this.log.error("{} LocalDynamicMetadataProvider contained neither a sourceManagerRef nor a sourceDirectory", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("Neither a sourceManagerRef nor sourceDirectory was supplied", new Location(parserContext.getReaderContext().getResource())));
        }
        if (sourceManagerRefOrBean instanceof String) {
            builder.addConstructorArgReference(sourceManagerRefOrBean);
        } else {
            builder.addConstructorArgValue((Object)sourceManagerRefOrBean);
        }
        if (sourceKeyGeneratorRefOrBean instanceof String) {
            builder.addConstructorArgReference(sourceKeyGeneratorRefOrBean);
        } else {
            builder.addConstructorArgValue((Object)sourceKeyGeneratorRefOrBean);
        }
    }
}

