/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.FileCachingHttpClientFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.HttpClientFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.InMemoryCachingHttpClientFactoryBean;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.TLSSocketFactoryFactoryBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HTTPMetadataProvidersParserSupport {
    @Nonnull
    @NotEmpty
    public static final String BASIC_AUTH_USER = "basicAuthUser";
    @Nonnull
    @NotEmpty
    public static final String BASIC_AUTH_PASSWORD = "basicAuthPassword";
    @Nonnull
    @NotEmpty
    public static final String METADATA_URL = "metadataURL";
    @Nonnull
    public static final QName TLS_TRUST_ENGINE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "TLSTrustEngine");
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(HTTPMetadataProvidersParserSupport.class);

    private HTTPMetadataProvidersParserSupport() {
    }

    protected static BeanDefinition buildTLSSocketFactory(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nullable String httpClientSecurityParametersRef, @Nullable BeanDefinition httpClientSecurityParameters) {
        Constraint.isNotNull((Object)LOG, (String)"LOG must be present");
        BeanDefinitionBuilder tlsSocketFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(TLSSocketFactoryFactoryBean.class);
        if (element.hasAttributeNS(null, "disregardTLSCertificate")) {
            tlsSocketFactoryBuilder.addPropertyValue("connectionDisregardTLSCertificate", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "disregardTLSCertificate")));
        } else if (element.hasAttributeNS(null, "disregardSslCertificate")) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"disregardSslCertificate", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"disregardTLSCertificate");
            tlsSocketFactoryBuilder.addPropertyValue("connectionDisregardTLSCertificate", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "disregardSslCertificate")));
        }
        if (httpClientSecurityParametersRef != null) {
            tlsSocketFactoryBuilder.addPropertyReference("httpClientSecurityParameters", httpClientSecurityParametersRef);
        }
        if (httpClientSecurityParameters != null) {
            tlsSocketFactoryBuilder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParameters);
        }
        return tlsSocketFactoryBuilder.getBeanDefinition();
    }

    @Nonnull
    protected static BeanDefinition buildBasicCredentials(Element element, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(UsernamePasswordCredentials.class);
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)BASIC_AUTH_USER, (String)parserContext.getReaderContext().getResource().getDescription(), (String)"httpClientSecurityParametersRef");
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)BASIC_AUTH_PASSWORD, (String)parserContext.getReaderContext().getResource().getDescription(), (String)"httpClientSecurityParametersRef");
        builder.setLazyInit(true);
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, BASIC_AUTH_USER)));
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, BASIC_AUTH_PASSWORD)));
        return builder.getBeanDefinition();
    }

    @Nullable
    protected static BeanDefinition parseTLSTrustEngine(@Nullable String tlsTrustEngineRef, @Nullable Element tlsTrustEngine, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientSecurityParameters.class);
        if (tlsTrustEngine != null) {
            Element trustEngine;
            if (tlsTrustEngineRef != null) {
                LOG.warn("<TLSTrustEngine> subelement overrides setting of tlsTrustEngineRef ");
            }
            if ((trustEngine = ElementSupport.getFirstChildElement((Node)tlsTrustEngine, (QName)AbstractMetadataProviderParser.TRUST_ENGINE_ELEMENT_NAME)) == null) {
                LOG.warn("{}:, Element {} did not contain a {} child element", new Object[]{parserContext.getReaderContext().getResource().getDescription(), TLS_TRUST_ENGINE_ELEMENT_NAME, AbstractMetadataProviderParser.TRUST_ENGINE_ELEMENT_NAME});
                return null;
            }
            builder.addPropertyValue("tLSTrustEngine", (Object)SpringSupport.parseCustomElement((Element)trustEngine, (ParserContext)parserContext));
        } else {
            if (tlsTrustEngineRef == null) {
                LOG.error("Internal error: tlsTrustEngineRef or TlsTrustEngine required");
                return null;
            }
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"tlsTrustEngineRef", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"inline <TrustEngine> element or httpClientSecurityParametersRef attribute");
            builder.addPropertyReference("tLSTrustEngine", tlsTrustEngineRef);
        }
        return builder.getBeanDefinition();
    }

    @Nonnull
    protected static BeanDefinitionBuilder buildCommonClientBuilder(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull String defaultCaching, @Nullable String httpClientSecurityParametersRef, @Nullable BeanDefinition httpClientSecurityParameters) {
        BeanDefinitionBuilder clientBuilder;
        String caching;
        if (element.hasAttributeNS(null, "httpCaching")) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"httpCaching", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"HttpClient bean via httpClientRef");
            caching = StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpCaching"));
        } else {
            caching = defaultCaching;
        }
        switch (caching) {
            case "none": {
                clientBuilder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
                break;
            }
            case "file": {
                clientBuilder = BeanDefinitionBuilder.genericBeanDefinition(FileCachingHttpClientFactoryBean.class);
                if (element.hasAttributeNS(null, "httpCacheDirectory")) {
                    DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"httpCacheDirectory", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"HttpClient bean via httpClientRef");
                    clientBuilder.addPropertyValue("cacheDirectory", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpCacheDirectory")));
                }
                if (element.hasAttributeNS(null, "httpMaxCacheEntries")) {
                    DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"httpMaxCacheEntries", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"HttpClient bean via httpClientRef");
                    clientBuilder.addPropertyValue("maxCacheEntries", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpMaxCacheEntries")));
                }
                if (!element.hasAttributeNS(null, "httpMaxCacheEntrySize")) break;
                DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"httpMaxCacheEntrySize", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"HttpClient bean via httpClientRef");
                clientBuilder.addPropertyValue("maxCacheEntrySize", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpMaxCacheEntrySize")));
                break;
            }
            case "memory": {
                clientBuilder = BeanDefinitionBuilder.genericBeanDefinition(InMemoryCachingHttpClientFactoryBean.class);
                if (element.hasAttributeNS(null, "httpMaxCacheEntries")) {
                    DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"httpMaxCacheEntries", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"HttpClient bean via httpClientRef");
                    clientBuilder.addPropertyValue("maxCacheEntries", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpMaxCacheEntries")));
                }
                if (!element.hasAttributeNS(null, "httpMaxCacheEntrySize")) break;
                DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"httpMaxCacheEntrySize", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"HttpClient bean via httpClientRef");
                clientBuilder.addPropertyValue("maxCacheEntrySize", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpMaxCacheEntrySize")));
                break;
            }
            default: {
                throw new BeanDefinitionParsingException(new Problem(String.format("Caching value '%s' is unsupported", caching), new Location(parserContext.getReaderContext().getResource())));
            }
        }
        clientBuilder.setLazyInit(true);
        if (element.hasAttributeNS(null, "requestTimeout")) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ATTRIBUTE, (String)"requestTimeout", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"connectionTimeout");
            clientBuilder.addPropertyValue("connectionTimeout", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "requestTimeout")));
        }
        if (element.hasAttributeNS(null, "connectionTimeout")) {
            clientBuilder.addPropertyValue("connectionTimeout", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "connectionTimeout")));
        }
        if (element.hasAttributeNS(null, "connectionRequestTimeout")) {
            clientBuilder.addPropertyValue("connectionRequestTimeout", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "connectionRequestTimeout")));
        }
        if (element.hasAttributeNS(null, "socketTimeout")) {
            clientBuilder.addPropertyValue("socketTimeout", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "socketTimeout")));
        }
        clientBuilder.addPropertyValue("tLSSocketFactory", (Object)HTTPMetadataProvidersParserSupport.buildTLSSocketFactory(element, parserContext, httpClientSecurityParametersRef, httpClientSecurityParameters));
        if (element.hasAttributeNS(null, "proxyHost")) {
            clientBuilder.addPropertyValue("connectionProxyHost", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "proxyHost")));
        }
        if (element.hasAttributeNS(null, "proxyPort")) {
            clientBuilder.addPropertyValue("connectionProxyPort", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "proxyPort")));
        }
        if (element.hasAttributeNS(null, "proxyUser")) {
            clientBuilder.addPropertyValue("connectionProxyUsername", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "proxyUser")));
        }
        if (element.hasAttributeNS(null, "proxyPassword")) {
            clientBuilder.addPropertyValue("connectionProxyPassword", (Object)element.getAttributeNS(null, "proxyPassword"));
        }
        return clientBuilder;
    }
}

