/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractMetadataProviderParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.persist.FilesystemLoadSaveManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractDynamicMetadataProviderParser
extends AbstractMetadataProviderParser {
    private static final String DEFAULT_PARSER_POOL_REF = "shibboleth.ParserPool";
    private Logger log = LoggerFactory.getLogger(AbstractDynamicMetadataProviderParser.class);

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        String timerRef = this.getTaskTimerRef(element);
        if (timerRef != null) {
            builder.addConstructorArgReference(timerRef);
        }
        if (element.hasAttributeNS(null, "refreshDelayFactor")) {
            builder.addPropertyValue("refreshDelayFactor", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "refreshDelayFactor")));
        }
        if (element.hasAttributeNS(null, "minCacheDuration")) {
            builder.addPropertyValue("minCacheDuration", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "minCacheDuration")));
        }
        if (element.hasAttributeNS(null, "maxCacheDuration")) {
            builder.addPropertyValue("maxCacheDuration", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxCacheDuration")));
        }
        if (element.hasAttributeNS(null, "negativeLookupCacheDuration")) {
            builder.addPropertyValue("negativeLookupCacheDuration", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "negativeLookupCacheDuration")));
        }
        if (element.hasAttributeNS(null, "maxIdleEntityData")) {
            builder.addPropertyValue("maxIdleEntityData", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxIdleEntityData")));
        }
        if (element.hasAttributeNS(null, "removeIdleEntityData")) {
            builder.addPropertyValue("removeIdleEntityData", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "removeIdleEntityData")));
        }
        if (element.hasAttributeNS(null, "cleanupTaskInterval")) {
            builder.addPropertyValue("cleanupTaskInterval", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "cleanupTaskInterval")));
        }
        if (element.hasAttributeNS(null, "expirationWarningThreshold")) {
            builder.addPropertyValue("expirationWarningThreshold", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "expirationWarningThreshold")));
        }
        if (element.hasAttributeNS(null, "indexesRef")) {
            builder.addPropertyReference("indexes", StringSupport.trimOrNull((String)element.getAttributeNS(null, "indexesRef")));
        }
        builder.addPropertyReference("parserPool", this.getParserPoolRef(element));
        this.processPersistentCachingProperties(element, parserContext, builder);
    }

    protected void processPersistentCachingProperties(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (element.hasAttributeNS(null, "persistentCacheManagerRef")) {
            builder.addPropertyReference("persistentCacheManager", StringSupport.trimOrNull((String)element.getAttributeNS(null, "persistentCacheManagerRef")));
            if (element.hasAttributeNS(null, "persistentCacheManagerDirectory")) {
                this.log.warn("{} Element contained both persistentCacheManagerRef and persistentCacheManagerDirectory, persistentCacheManagerDirectory will be ignored", (Object)parserContext.getReaderContext().getResource().getDescription());
            }
        } else if (element.hasAttributeNS(null, "persistentCacheManagerDirectory")) {
            String cacheDirectory = StringSupport.trimOrNull((String)element.getAttributeNS(null, "persistentCacheManagerDirectory"));
            this.log.debug("{} Building internally-constructed FilesystemLoadSaveManager with base directory: {}", (Object)parserContext.getReaderContext().getResource().getDescription(), (Object)cacheDirectory);
            BeanDefinitionBuilder cacheManagerBuilder = BeanDefinitionBuilder.genericBeanDefinition(FilesystemLoadSaveManager.class);
            cacheManagerBuilder.addConstructorArgValue((Object)cacheDirectory);
            builder.addPropertyValue("persistentCacheManager", (Object)cacheManagerBuilder.getBeanDefinition());
        }
        if (element.hasAttributeNS(null, "persistentCacheKeyGeneratorRef")) {
            builder.addPropertyReference("persistentCacheKeyGenerator", StringSupport.trimOrNull((String)element.getAttributeNS(null, "persistentCacheKeyGeneratorRef")));
        }
        if (element.hasAttributeNS(null, "initializeFromPersistentCacheInBackground")) {
            builder.addPropertyValue("initializeFromPersistentCacheInBackground", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "initializeFromPersistentCacheInBackground")));
        }
        if (element.hasAttributeNS(null, "backgroundInitializationFromCacheDelay")) {
            builder.addPropertyValue("backgroundInitializationFromCacheDelay", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "backgroundInitializationFromCacheDelay")));
        }
        if (element.hasAttributeNS(null, "initializationFromCachePredicateRef")) {
            builder.addPropertyReference("initializationFromCachePredicate", StringSupport.trimOrNull((String)element.getAttributeNS(null, "initializationFromCachePredicateRef")));
        }
    }

    protected String getTaskTimerRef(Element element) {
        if (element.hasAttributeNS(null, "taskTimerRef")) {
            return StringSupport.trimOrNull((String)StringSupport.trimOrNull((String)element.getAttributeNS(null, "taskTimerRef")));
        }
        return null;
    }

    protected String getParserPoolRef(Element element) {
        String parserPoolRef = null;
        if (element.hasAttributeNS(null, "parserPoolRef")) {
            parserPoolRef = StringSupport.trimOrNull((String)StringSupport.trimOrNull((String)element.getAttributeNS(null, "parserPoolRef")));
        }
        if (parserPoolRef == null) {
            parserPoolRef = DEFAULT_PARSER_POOL_REF;
        }
        return parserPoolRef;
    }
}

