/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.filter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureValidationParametersResolver;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class SignatureValidationCriteriaSetFactoryBean
implements FactoryBean<CriteriaSet> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SignatureValidationCriteriaSetFactoryBean.class);
    @Nullable
    private List<SignatureValidationConfiguration> signatureValidationConfigs;
    @Nullable
    private SignatureValidationParametersResolver signatureValidationResolver;
    @Nullable
    private Collection<Criterion> otherCriteria;
    private boolean includeOpenSAMLGlobalConfig = true;

    public void setSignatureValidationConfigurations(@Nullable List<SignatureValidationConfiguration> newConfigs) {
        this.signatureValidationConfigs = newConfigs;
    }

    public void setSignatureValidationParametersResolver(@Nullable SignatureValidationParametersResolver newResolver) {
        this.signatureValidationResolver = newResolver;
    }

    public void setOtherCriteria(@Nullable Collection<Criterion> newCriteria) {
        this.otherCriteria = newCriteria;
    }

    public void setIncludeOpenSAMLGlobalConfig(boolean flag) {
        this.includeOpenSAMLGlobalConfig = flag;
    }

    public Class<?> getObjectType() {
        return CriteriaSet.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public CriteriaSet getObject() throws Exception {
        this.log.debug("Building CriteriaSet based on factory bean inputs");
        CriteriaSet criteriaSet = new CriteriaSet();
        if (this.otherCriteria != null && !this.otherCriteria.isEmpty()) {
            this.log.debug("Added generic collection of other criteria");
            criteriaSet.addAll(this.otherCriteria);
        }
        ArrayList<SignatureValidationConfiguration> sigConfigs = new ArrayList<SignatureValidationConfiguration>();
        if (this.signatureValidationConfigs != null && !this.signatureValidationConfigs.isEmpty()) {
            sigConfigs.addAll(this.signatureValidationConfigs);
        }
        if (this.includeOpenSAMLGlobalConfig) {
            sigConfigs.add(SecurityConfigurationSupport.getGlobalSignatureValidationConfiguration());
        }
        if (!sigConfigs.isEmpty()) {
            CriteriaSet configCriteria;
            SignatureValidationParameters params;
            SignatureValidationParametersResolver paramsResolver;
            this.log.debug("Resolving SignatureValidationParameters from supplied SignatureValidationConfigurations");
            if (criteriaSet.contains(SignatureValidationParametersCriterion.class)) {
                this.log.warn("Supplied criteria contained already an instance of SignatureValidationParametersCriterion, it will be replaced by the one to be resolved");
            }
            if ((paramsResolver = this.signatureValidationResolver) == null) {
                paramsResolver = new BasicSignatureValidationParametersResolver();
            }
            if ((params = (SignatureValidationParameters)paramsResolver.resolveSingle((Object)(configCriteria = new CriteriaSet(new Criterion[]{new SignatureValidationConfigurationCriterion(sigConfigs)})))) != null) {
                criteriaSet.add((Object)new SignatureValidationParametersCriterion(params), true);
            }
        }
        return criteriaSet;
    }
}

