/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.factory.AbstractComponentAwareFactoryBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.cryptacular.EncodingException;
import org.cryptacular.StreamException;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.trust.impl.ExplicitKeyTrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.Resource;

public class StaticExplicitKeyFactoryBean
extends AbstractComponentAwareFactoryBean<ExplicitKeyTrustEngine> {
    private Logger log = LoggerFactory.getLogger(StaticExplicitKeyFactoryBean.class);
    private List<Resource> keyResources = Collections.emptyList();
    private List<Resource> certificateResources = Collections.emptyList();

    public void setPublicKeys(@Nullable List<Resource> keys) {
        this.keyResources = keys != null ? keys : Collections.emptyList();
    }

    public void setCertificates(@Nullable List<Resource> certs) {
        this.certificateResources = certs != null ? certs : Collections.emptyList();
    }

    @Nullable
    @NonnullElements
    protected List<Credential> getCredentials() {
        Throwable throwable;
        InputStream is;
        ArrayList<Credential> credentials = new ArrayList<Credential>(this.keyResources.size() + this.certificateResources.size());
        for (Resource f : this.keyResources) {
            try {
                is = f.getInputStream();
                throwable = null;
                try {
                    credentials.add((Credential)new BasicCredential(KeyPairUtil.readPublicKey((InputStream)is)));
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | EncodingException | StreamException e) {
                this.log.error("Could not decode public key from {}", (Object)f.getDescription(), (Object)e);
                throw new FatalBeanException("Could not decode public key from: " + f.getDescription(), e);
            }
        }
        for (Resource f : this.certificateResources) {
            try {
                is = f.getInputStream();
                throwable = null;
                try {
                    Collection raw = X509Support.decodeCertificates((InputStream)is);
                    for (X509Certificate x : Collections2.filter((Collection)raw, (Predicate)Predicates.notNull())) {
                        credentials.add((Credential)new BasicX509Credential(x));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | CertificateException e) {
                this.log.error("Could not decode certificate from {}", (Object)f.getDescription(), (Object)e);
                throw new FatalBeanException("Could not decode certificate from: " + f.getDescription(), (Throwable)e);
            }
        }
        return credentials;
    }

    public Class<?> getObjectType() {
        return ExplicitKeyTrustEngine.class;
    }

    protected ExplicitKeyTrustEngine doCreateInstance() throws Exception {
        return new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver(this.getCredentials()));
    }
}

