/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.trustengine.impl;

import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.spring.relyingparty.security.impl.AbstractWarningSecurityParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractPKIXValidationInfoParser
extends AbstractWarningSecurityParser {
    private static final QName CERTIFICATE = new QName("urn:mace:shibboleth:2.0:security", "Certificate");
    private static final QName CRL = new QName("urn:mace:shibboleth:2.0:security", "CRL");

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.addPropertyValue("configDescription", (Object)parserContext.getReaderContext().getResource().getDescription());
        if (element.hasAttributeNS(null, "verifyDepth")) {
            builder.addPropertyValue("verifyDepth", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "verifyDepth")));
        }
        List certificates = ElementSupport.getChildElements((Node)element, (QName)CERTIFICATE);
        ManagedList certStrings = new ManagedList(certificates.size());
        for (Element cert : certificates) {
            certStrings.add(cert.getTextContent());
        }
        builder.addPropertyValue("certificates", (Object)certStrings);
        List crls = ElementSupport.getChildElements((Node)element, (QName)CRL);
        ManagedList crlStrings = new ManagedList(certificates.size());
        for (Element crl : crls) {
            crlStrings.add(crl.getTextContent());
        }
        builder.addPropertyValue("CRLs", (Object)crlStrings);
    }
}

