/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.AbstractReloadingMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.FileBackedHTTPMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.impl.HTTPMetadataProvidersParserSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTTPMetadataProviderParser
extends AbstractReloadingMetadataProviderParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "HTTPMetadataProvider");
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_CACHING = "none";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPMetadataProviderParser.class);

    protected Class<? extends HTTPMetadataResolver> getNativeBeanClass(Element element) {
        return HTTPMetadataResolver.class;
    }

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (ELEMENT_NAME.equals(DOMTypeSupport.getXSIType((Element)element))) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.XSITYPE, (String)ELEMENT_NAME.toString(), (String)parserContext.getReaderContext().getResource().getDescription(), (String)FileBackedHTTPMetadataProviderParser.ELEMENT_NAME.toString());
        }
        super.doNativeParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "cacheDuration")) {
            this.log.error("{}: cacheDuration is not supported", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("cacheDuration is not supported", new Location(parserContext.getReaderContext().getResource())));
        }
        if (element.hasAttributeNS(null, "maintainExpiredMetadata")) {
            this.log.error("{}: maintainExpiredMetadata is not supported", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanDefinitionParsingException(new Problem("maintainExpiredMetadata is not supported", new Location(parserContext.getReaderContext().getResource())));
        }
        String tlsTrustEngineRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "tlsTrustEngineRef"));
        Element tlsTrustEngine = ElementSupport.getFirstChildElement((Node)element, (QName)HTTPMetadataProvidersParserSupport.TLS_TRUST_ENGINE_ELEMENT_NAME);
        String httpClientSecurityParametersRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpClientSecurityParametersRef"));
        BeanDefinition httpClientSecurityParameters = null;
        if (httpClientSecurityParametersRef != null) {
            if (tlsTrustEngine != null || tlsTrustEngineRef != null) {
                this.log.warn("httpClientSecurityParametersRef overrides tlsTrustEngineRef or <TrustEngine> subelement");
            }
            builder.addPropertyReference("httpClientSecurityParameters", httpClientSecurityParametersRef);
        } else if (tlsTrustEngine != null || tlsTrustEngineRef != null) {
            httpClientSecurityParameters = HTTPMetadataProvidersParserSupport.parseTLSTrustEngine(tlsTrustEngineRef, tlsTrustEngine, parserContext);
            builder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParameters);
        }
        if (element.hasAttributeNS(null, "httpClientRef")) {
            builder.addConstructorArgReference(StringSupport.trimOrNull((String)element.getAttributeNS(null, "httpClientRef")));
            if (element.hasAttributeNS(null, "requestTimeout") || element.hasAttributeNS(null, "connectionTimeout") || element.hasAttributeNS(null, "connectionRequestTimeout") || element.hasAttributeNS(null, "socketTimeout") || element.hasAttributeNS(null, "disregardSslCertificate") || element.hasAttributeNS(null, "disregardTLSCertificate") || element.hasAttributeNS(null, "proxyHost") || element.hasAttributeNS(null, "proxyPort") || element.hasAttributeNS(null, "proxyUser") || element.hasAttributeNS(null, "proxyPassword")) {
                this.log.warn("httpClientRef overrides settings for requestTimeout, connectionTimeout, connectionRequestTimeout, socketTimeout, disregardSslCertificate, disregardTLSCertificate,  proxyHost, proxyPort, proxyUser and proxyPassword");
            }
        } else {
            builder.addConstructorArgValue((Object)this.buildHttpClient(element, parserContext, httpClientSecurityParametersRef, httpClientSecurityParameters));
        }
        builder.addConstructorArgValue((Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "metadataURL")));
        if (element.hasAttributeNS(null, "basicAuthUser") || element.hasAttributeNS(null, "basicAuthPassword")) {
            builder.addPropertyValue("basicCredentials", (Object)HTTPMetadataProvidersParserSupport.buildBasicCredentials(element, parserContext));
        }
    }

    private BeanDefinition buildHttpClient(Element element, ParserContext parserContext, @Nullable String httpClientSecurityParametersRef, @Nullable BeanDefinition httpClientSecurityParameters) {
        return HTTPMetadataProvidersParserSupport.buildCommonClientBuilder(element, parserContext, DEFAULT_CACHING, httpClientSecurityParametersRef, httpClientSecurityParameters).getBeanDefinition();
    }
}

