/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.saml.metadata.RelyingPartyMetadataProvider;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractMetadataProviderParser
extends AbstractSingleBeanDefinitionParser {
    public static final String SECURITY_NAMESPACE = "urn:mace:shibboleth:2.0:security";
    public static final String RP_NAMESPACE = "urn:mace:shibboleth:2.0:relying-party";
    public static final String METADATA_NAMESPACE = "urn:mace:shibboleth:2.0:metadata";
    public static final QName METADATA_FILTER_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "MetadataFilter");
    public static final QName CHAINING_PROVIDER_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "ChainingMetadataProvider");
    public static final QName RELYING_PARTY_GROUP_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:relying-party", "RelyingPartyGroup");
    public static final QName TRUST_ENGINE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "TrustEngine");
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataProviderParser.class);

    private boolean isPresentNotChaining(@Nonnull Element element, @Nonnull String attribute) {
        if (!element.hasAttributeNS(null, attribute)) {
            return false;
        }
        if (CHAINING_PROVIDER_ELEMENT_NAME.equals(DOMTypeSupport.getXSIType((Element)element))) {
            this.log.warn("{} is not valid for {}", (Object)attribute, (Object)CHAINING_PROVIDER_ELEMENT_NAME.getLocalPart());
            return false;
        }
        return true;
    }

    private boolean isTopMost(@Nonnull Element element) {
        Node parent = element.getParentNode();
        if (parent.getNodeType() == 9) {
            return true;
        }
        if (parent.getNodeType() != 1) {
            return false;
        }
        return RELYING_PARTY_GROUP_ELEMENT_NAME.getLocalPart().equals(parent.getLocalName()) && RELYING_PARTY_GROUP_ELEMENT_NAME.getNamespaceURI().equals(parent.getNamespaceURI());
    }

    protected abstract Class<? extends MetadataResolver> getNativeBeanClass(Element var1);

    protected final Class<? extends MetadataResolver> getBeanClass(Element element) {
        if (this.isTopMost(element)) {
            return RelyingPartyMetadataProvider.class;
        }
        return this.getNativeBeanClass(element);
    }

    protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        if (this.isTopMost(element)) {
            builder.setInitMethodName("initialize");
            builder.setDestroyMethodName("destroy");
            builder.setLazyInit(true);
            BeanDefinitionBuilder childBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getNativeBeanClass(element));
            this.doNativeParse(element, parserContext, childBeanDefinitionBuilder);
            builder.addPropertyValue("embeddedResolver", (Object)childBeanDefinitionBuilder.getBeanDefinition());
            if (element.hasAttributeNS(null, "sortKey")) {
                builder.addPropertyValue("sortKey", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "sortKey")));
            }
        } else {
            if (element.hasAttributeNS(null, "sortKey")) {
                this.log.warn("{} sortKey is only valid on 'top level' MetadataProviders", (Object)parserContext.getReaderContext().getResource().getDescription());
            }
            this.doNativeParse(element, parserContext, builder);
        }
    }

    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List trustEngines;
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        builder.setLazyInit(true);
        builder.addPropertyValue("id", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "id")));
        if (this.isPresentNotChaining(element, "failFastInitialization")) {
            builder.addPropertyValue("failFastInitialization", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "failFastInitialization")));
        }
        if (this.isPresentNotChaining(element, "requireValidMetadata")) {
            builder.addPropertyValue("requireValidMetadata", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "requireValidMetadata")));
        }
        this.processPredicateOptions(element, parserContext, builder);
        List filters = ElementSupport.getChildElements((Node)element, (QName)METADATA_FILTER_ELEMENT_NAME);
        if (null != filters) {
            if (filters.size() == 1) {
                builder.addPropertyValue("metadataFilter", (Object)SpringSupport.parseCustomElements((Collection)filters, (ParserContext)parserContext));
            } else if (filters.size() > 1) {
                BeanDefinitionBuilder chainBuilder = BeanDefinitionBuilder.genericBeanDefinition(MetadataFilterChain.class);
                chainBuilder.addPropertyValue("filters", (Object)SpringSupport.parseCustomElements((Collection)filters, (ParserContext)parserContext));
                builder.addPropertyValue("metadataFilter", (Object)chainBuilder.getBeanDefinition());
            }
        }
        if ((trustEngines = ElementSupport.getChildElements((Node)element, (QName)TRUST_ENGINE_ELEMENT_NAME)) != null && !trustEngines.isEmpty()) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.ELEMENT, (String)"<TrustEngine> inside <MetadataProvider>", (String)parserContext.getReaderContext().getResource().getDescription(), (String)"Inside <Filter>");
            SpringSupport.parseCustomElements((Collection)trustEngines, (ParserContext)parserContext);
        }
    }

    private void processPredicateOptions(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (this.isPresentNotChaining(element, "satisfyAnyPredicates")) {
            builder.addPropertyValue("satisfyAnyPredicates", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "satisfyAnyPredicates")));
        }
        if (this.isPresentNotChaining(element, "useDefaultPredicateRegistry")) {
            builder.addPropertyValue("useDefaultPredicateRegistry", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "useDefaultPredicateRegistry")));
        }
        if (this.isPresentNotChaining(element, "criterionPredicateRegistryRef")) {
            builder.addPropertyReference("criterionPredicateRegistry", StringSupport.trimOrNull((String)element.getAttributeNS(null, "criterionPredicateRegistryRef")));
        }
    }
}

