/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.filter.impl;

import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.opensaml.saml.metadata.resolver.filter.impl.RequiredValidUntilFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class RequiredValidUntilFactoryBean
extends AbstractFactoryBean<RequiredValidUntilFilter> {
    @Nullable
    private String maxValidityIntervalDuration;
    private final Logger log = LoggerFactory.getLogger(RequiredValidUntilFactoryBean.class);

    public void setMaxValidityInterval(String s) {
        this.maxValidityIntervalDuration = s;
    }

    public Class<RequiredValidUntilFilter> getObjectType() {
        return RequiredValidUntilFilter.class;
    }

    protected RequiredValidUntilFilter createInstance() throws Exception {
        RequiredValidUntilFilter value = new RequiredValidUntilFilter();
        if (null != this.maxValidityIntervalDuration) {
            if (this.maxValidityIntervalDuration.startsWith("P")) {
                value.setMaxValidityInterval(DOMTypeSupport.durationToLong((String)this.maxValidityIntervalDuration));
            } else {
                if (this.maxValidityIntervalDuration.startsWith("-P")) {
                    throw new IllegalArgumentException("Negative durations are not supported");
                }
                long durationInMs = 1000L * Long.valueOf(this.maxValidityIntervalDuration);
                this.log.warn("Numerical duration form is deprecated. The property 'maxValidityInterval' on RequiredValidUntil metadata filter should use the duration notation: {}", (Object)DOMTypeSupport.longToDuration((long)durationInMs));
                value.setMaxValidityInterval(durationInMs);
            }
        }
        return value;
    }
}

