/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.factory.AbstractComponentAwareFactoryBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.PKIXX509CredentialTrustEngine;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.Resource;

public class StaticPKIXFactoryBean
extends AbstractComponentAwareFactoryBean<PKIXX509CredentialTrustEngine> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(StaticPKIXFactoryBean.class);
    @Nullable
    private List<Resource> certificateResources;
    @Nullable
    private List<Resource> crlResources;
    @Nullable
    private Integer verifyDepth;

    public Class<?> getObjectType() {
        return PKIXX509CredentialTrustEngine.class;
    }

    public void setCertificates(@Nullable List<Resource> certs) {
        this.certificateResources = certs;
    }

    public void setCRLs(@Nullable List<Resource> crls) {
        this.crlResources = crls;
    }

    public void setVerifyDepth(int depth) {
        this.verifyDepth = depth;
    }

    @Nullable
    @NonnullElements
    protected List<X509Certificate> getCertificates() {
        if (this.certificateResources == null) {
            return null;
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(this.certificateResources.size());
        for (Resource f : this.certificateResources) {
            try {
                InputStream is = f.getInputStream();
                Throwable throwable = null;
                try {
                    certificates.addAll(X509Support.decodeCertificates((InputStream)is));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | CertificateException e) {
                this.log.error("Could not decode Certificate at {}", (Object)f.getDescription(), (Object)e);
                throw new FatalBeanException("Could not decode provided CertificateFile: " + f.getDescription(), (Throwable)e);
            }
        }
        return certificates;
    }

    @Nonnull
    @NonnullElements
    protected List<X509CRL> getCRLs() {
        if (this.crlResources == null) {
            return null;
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(this.crlResources.size());
        for (Resource crlFile : this.crlResources) {
            try {
                InputStream is = crlFile.getInputStream();
                Throwable throwable = null;
                try {
                    crls.addAll(X509Support.decodeCRLs((InputStream)is));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | CRLException e) {
                this.log.error("Could not decode CRL file at {}: {}", (Object)crlFile.getDescription(), (Object)e);
                throw new FatalBeanException("Could not decode provided CRL file " + crlFile.getDescription(), (Throwable)e);
            }
        }
        return crls;
    }

    protected PKIXX509CredentialTrustEngine doCreateInstance() throws Exception {
        BasicPKIXValidationInformation info = new BasicPKIXValidationInformation(this.getCertificates(), this.getCRLs(), this.verifyDepth);
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(Collections.singletonList(info), null, true);
        return new PKIXX509CredentialTrustEngine((PKIXValidationInformationResolver)resolver);
    }
}

