/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResolveAttributes
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ResolveAttributes.class);
    @Nonnull
    private final ReloadableService<AttributeResolver> attributeResolverService;
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> recipientLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> principalNameLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, AuthenticationContext> authnContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextCreationStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> attributesLookupStrategy;
    private boolean maskFailures;
    @Nullable
    private String resolutionLabel;
    private boolean createResolutionContext;
    @Nullable
    private AuthenticationContext authenticationContext;

    public ResolveAttributes(@Nonnull ReloadableService<AttributeResolver> resolverService) {
        this.attributeResolverService = (ReloadableService)Constraint.isNotNull(resolverService, (String)"AttributeResolver cannot be null");
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
        this.recipientLookupStrategy = new RelyingPartyIdLookupFunction();
        this.principalNameLookupStrategy = Functions.compose((Function)new SubjectContextPrincipalLookupFunction(), (Function)new ChildContextLookup(SubjectContext.class));
        this.authnContextLookupStrategy = new ChildContextLookup(AuthenticationContext.class);
        this.attributeContextCreationStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class, true), (Function)new ChildContextLookup(RelyingPartyContext.class));
        this.attributesLookupStrategy = FunctionSupport.constant(Collections.emptyList());
        this.maskFailures = true;
        this.createResolutionContext = true;
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = strategy;
    }

    public void setRecipientLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.recipientLookupStrategy = strategy;
    }

    public void setPrincipalNameLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalNameLookupStrategy = strategy;
    }

    public void setAuthenticationContextLookupStrategy(@Nullable Function<ProfileRequestContext, AuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authnContextLookupStrategy = strategy;
    }

    public void setAttributeContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext creation strategy cannot be null");
    }

    public void setAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Attributes lookup strategy cannot be null");
    }

    public void setAttributesToResolve(@Nonnull @NonnullElements Collection<String> attributeIds) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(attributeIds, (String)"Attribute ID collection cannot be null");
        this.attributesLookupStrategy = FunctionSupport.constant((Object)StringSupport.normalizeStringCollection(attributeIds));
    }

    public void setMaskFailures(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maskFailures = flag;
    }

    public void setResolutionLabel(@Nullable String label) {
        this.resolutionLabel = StringSupport.trimOrNull((String)label);
    }

    public void setCreateResolutionContext(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.createResolutionContext = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.authnContextLookupStrategy != null) {
            this.authenticationContext = (AuthenticationContext)this.authnContextLookupStrategy.apply((Object)profileRequestContext);
        }
        if (this.authenticationContext == null) {
            this.log.debug("{} No authentication context available.", (Object)this.getLogPrefix());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AttributeResolutionContext resolutionContext;
        if (this.createResolutionContext) {
            resolutionContext = (AttributeResolutionContext)profileRequestContext.getSubcontext(AttributeResolutionContext.class, true);
            this.populateResolutionContext(profileRequestContext, resolutionContext);
        } else {
            resolutionContext = (AttributeResolutionContext)profileRequestContext.getSubcontext(AttributeResolutionContext.class);
            if (resolutionContext == null) {
                this.log.error("{} Unable to locate AttributeResolutionContext", (Object)this.getLogPrefix());
                if (!this.maskFailures) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToResolveAttributes");
                }
                return;
            }
        }
        ServiceableComponent component = null;
        try {
            component = this.attributeResolverService.getServiceableComponent();
            if (null == component) {
                this.log.error("{} Error resolving attributes: Invalid Attribute resolver configuration", (Object)this.getLogPrefix());
                if (!this.maskFailures) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToResolveAttributes");
                }
            } else {
                AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
                attributeResolver.resolveAttributes(resolutionContext);
                profileRequestContext.removeSubcontext((BaseContext)resolutionContext);
                AttributeContext attributeCtx = (AttributeContext)this.attributeContextCreationStrategy.apply((Object)profileRequestContext);
                if (null == attributeCtx) {
                    throw new ResolutionException("Unable to create or locate AttributeContext to populate");
                }
                attributeCtx.setIdPAttributes(resolutionContext.getResolvedIdPAttributes().values());
                attributeCtx.setUnfilteredIdPAttributes(resolutionContext.getResolvedIdPAttributes().values());
            }
        }
        catch (ResolutionException e) {
            this.log.error("{} Error resolving attributes", (Object)this.getLogPrefix(), (Object)e);
            if (!this.maskFailures) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToResolveAttributes");
            }
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }

    private void populateResolutionContext(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeResolutionContext resolutionContext) {
        AuthenticationResult result;
        resolutionContext.setResolutionLabel(this.resolutionLabel);
        if (resolutionContext.getRequestedIdPAttributeNames() == null || resolutionContext.getRequestedIdPAttributeNames().isEmpty()) {
            resolutionContext.setRequestedIdPAttributeNames((Collection)this.attributesLookupStrategy.apply((Object)profileRequestContext));
        }
        if (null != this.principalNameLookupStrategy) {
            resolutionContext.setPrincipal((String)this.principalNameLookupStrategy.apply((Object)profileRequestContext));
        } else {
            resolutionContext.setPrincipal(null);
        }
        resolutionContext.setPrincipalAuthenticationMethod(null);
        if (null != this.authenticationContext && null != (result = this.authenticationContext.getAuthenticationResult())) {
            resolutionContext.setPrincipalAuthenticationMethod(result.getAuthenticationFlowId());
        }
        if (this.recipientLookupStrategy != null) {
            resolutionContext.setAttributeRecipientID((String)this.recipientLookupStrategy.apply((Object)profileRequestContext));
        } else {
            resolutionContext.setAttributeRecipientID(null);
        }
        if (this.issuerLookupStrategy != null) {
            resolutionContext.setAttributeIssuerID((String)this.issuerLookupStrategy.apply((Object)profileRequestContext));
        } else {
            resolutionContext.setAttributeIssuerID(null);
        }
    }
}

