/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorAction;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorResult;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteProfileInterceptorResultToStorage
extends AbstractProfileInterceptorAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(WriteProfileInterceptorResultToStorage.class);
    @Nullable
    private ProfileInterceptorFlowDescriptor flowDescriptor;
    @Nullable
    private List<ProfileInterceptorResult> results;
    @Nullable
    private StorageService storageService;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        if (!super.doPreExecute(profileRequestContext, interceptorContext)) {
            return false;
        }
        this.results = interceptorContext.getResults();
        if (this.results.isEmpty()) {
            this.log.debug("{} No results available from interceptor context, nothing to store", (Object)this.getLogPrefix());
            return false;
        }
        this.flowDescriptor = interceptorContext.getAttemptedFlow();
        if (this.flowDescriptor == null) {
            this.log.warn("{} No flow descriptor within interceptor context", (Object)this.getLogPrefix());
            return false;
        }
        this.storageService = this.flowDescriptor.getStorageService();
        if (this.storageService == null) {
            this.log.warn("{} No storage service available from interceptor flow descriptor", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        try {
            for (ProfileInterceptorResult result : this.results) {
                this.store(result);
            }
        }
        catch (IOException e) {
            this.log.error("{} Unable to write results '{}' to storage", new Object[]{this.getLogPrefix(), this.results, e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    protected void store(@Nonnull ProfileInterceptorResult result) throws IOException {
        String context = result.getStorageContext();
        String key = result.getStorageKey();
        String value = result.getStorageValue();
        Long expiration = result.getStorageExpiration();
        int attempts = 10;
        boolean success = false;
        do {
            if (success = this.storageService.create(context, key, value, expiration)) continue;
            success = this.storageService.update(context, key, value, expiration);
        } while (!success && attempts-- > 0);
        if (!success) {
            this.log.error("{} Exhausted retry attempts storing result '{}'", (Object)this.getLogPrefix(), (Object)result);
        }
    }
}

