/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RootContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterAttributes
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterAttributes.class);
    @Nonnull
    private final ReloadableService<AttributeFilter> attributeFilterService;
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> recipientLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeFilterContext> filterContextCreationStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> principalNameLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AuthenticationContext> authnContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy;
    @Nonnull
    private Function<AttributeFilterContext, SAMLMetadataContext> metadataFromFilterLookupStrategy;
    private boolean maskFailures;
    @Nullable
    private AuthenticationContext authenticationContext;
    @Nullable
    private AttributeContext attributeContext;

    public FilterAttributes(@Nonnull ReloadableService<AttributeFilter> filterService) {
        this.attributeFilterService = (ReloadableService)Constraint.isNotNull(filterService, (String)"Service cannot be null");
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
        this.recipientLookupStrategy = new RelyingPartyIdLookupFunction();
        this.attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
        this.principalNameLookupStrategy = Functions.compose((Function)new SubjectContextPrincipalLookupFunction(), (Function)new ChildContextLookup(SubjectContext.class));
        this.authnContextLookupStrategy = new ChildContextLookup(AuthenticationContext.class);
        this.metadataContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLMetadataContext.class), (Function)Functions.compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class), (Function)new InboundMessageContextLookup()));
        this.metadataFromFilterLookupStrategy = Functions.compose((Function)new Function<ProfileRequestContext, SAMLMetadataContext>(){

            public SAMLMetadataContext apply(ProfileRequestContext input) {
                return (SAMLMetadataContext)FilterAttributes.this.metadataContextLookupStrategy.apply((Object)input);
            }
        }, (Function)new RootContextLookup());
        this.filterContextCreationStrategy = Functions.compose((Function)new ChildContextLookup(AttributeFilterContext.class, true), (Function)new ChildContextLookup(RelyingPartyContext.class));
        this.maskFailures = true;
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = strategy;
    }

    public void setRecipientLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.recipientLookupStrategy = strategy;
    }

    public void setFilterContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AttributeFilterContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.filterContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext creation strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setPrincipalNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Principal name lookup strategy cannot be null");
    }

    public void setAuthenticationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authnContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthenticationContext lookup strategy cannot be null");
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"MetadataContext lookup strategy cannot be null");
        this.metadataFromFilterLookupStrategy = Functions.compose(this.metadataContextLookupStrategy, (Function)new RootContextLookup());
    }

    public void setMaskFailures(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maskFailures = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.attributeContext = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        if (this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        this.authenticationContext = (AuthenticationContext)this.authnContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.authenticationContext == null) {
            this.log.debug("{} No authentication context available.", (Object)this.getLogPrefix());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AttributeFilterContext filterContext = (AttributeFilterContext)this.filterContextCreationStrategy.apply((Object)profileRequestContext);
        if (filterContext == null) {
            this.log.error("{} Unable to locate or create AttributeFilterContext", (Object)this.getLogPrefix());
            if (this.maskFailures) {
                this.log.warn("Filter error masked, clearing resolved attributes");
                this.attributeContext.setIdPAttributes(null);
            } else {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToFilterAttributes");
            }
            return;
        }
        this.populateFilterContext(profileRequestContext, filterContext);
        ServiceableComponent component = null;
        try {
            component = this.attributeFilterService.getServiceableComponent();
            if (null == component) {
                this.log.error("{} Error encountered while filtering attributes : Invalid Attribute Filter configuration", (Object)this.getLogPrefix());
                if (this.maskFailures) {
                    this.log.warn("Filter error masked, clearing resolved attributes");
                    this.attributeContext.setIdPAttributes(null);
                } else {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToFilterAttributes");
                }
            } else {
                AttributeFilter filter = (AttributeFilter)component.getComponent();
                filter.filterAttributes(filterContext);
                filterContext.getParent().removeSubcontext((BaseContext)filterContext);
                this.attributeContext.setIdPAttributes(filterContext.getFilteredIdPAttributes().values());
            }
        }
        catch (AttributeFilterException e) {
            this.log.error("{} Error encountered while filtering attributes", (Object)this.getLogPrefix(), (Object)e);
            if (this.maskFailures) {
                this.log.warn("Filter error masked, clearing resolved attributes");
                this.attributeContext.setIdPAttributes(null);
            } else {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToFilterAttributes");
            }
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }

    private void populateFilterContext(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeFilterContext filterContext) {
        AuthenticationResult result;
        filterContext.setPrincipal((String)this.principalNameLookupStrategy.apply((Object)profileRequestContext));
        filterContext.setPrincipalAuthenticationMethod(null);
        if (null != this.authenticationContext && null != (result = this.authenticationContext.getAuthenticationResult())) {
            filterContext.setPrincipalAuthenticationMethod(result.getAuthenticationFlowId());
        }
        if (this.recipientLookupStrategy != null) {
            filterContext.setAttributeRecipientID((String)this.recipientLookupStrategy.apply((Object)profileRequestContext));
        } else {
            filterContext.setAttributeRecipientID(null);
        }
        if (this.issuerLookupStrategy != null) {
            filterContext.setAttributeIssuerID((String)this.issuerLookupStrategy.apply((Object)profileRequestContext));
        } else {
            filterContext.setAttributeIssuerID(null);
        }
        filterContext.setRequesterMetadataContextLookupStrategy(this.metadataFromFilterLookupStrategy);
        if (filterContext.getPrefilteredIdPAttributes().isEmpty()) {
            filterContext.setPrefilteredIdPAttributes(this.attributeContext.getIdPAttributes().values());
        }
    }
}

