/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.core.io.Resource;

public class ScriptedContextLookupFunction<T extends BaseContext>
extends AbstractScriptEvaluator
implements ContextDataLookupFunction<T, Object> {
    @Nonnull
    private final Class<T> inputClass;

    protected ScriptedContextLookupFunction(@Nonnull Class<T> inClass, @Nonnull EvaluableScript theScript, @Nullable String extraInfo) {
        super(theScript);
        this.inputClass = (Class)Constraint.isNotNull(inClass, (String)"Supplied inputClass cannot be null");
        this.setLogPrefix("Scripted Function from " + extraInfo + ":");
    }

    protected ScriptedContextLookupFunction(@Nonnull Class<T> inClass, @Nonnull EvaluableScript theScript) {
        super(theScript);
        this.inputClass = (Class)Constraint.isNotNull(inClass, (String)"Supplied inputClass cannot be null");
        this.setLogPrefix("Anonymous Scripted Function:");
    }

    protected ScriptedContextLookupFunction(@Nonnull Class<T> inClass, @Nonnull EvaluableScript theScript, @Nullable String extraInfo, @Nullable Class outputType) {
        this(inClass, theScript, extraInfo);
        this.setOutputType(outputType);
    }

    @Nullable
    public Object getCustomObject() {
        return super.getCustomObject();
    }

    public Object apply(@Nullable T context) {
        if (null != context && !this.inputClass.isInstance(context)) {
            throw new ClassCastException(this.getLogPrefix() + " Input was type " + context.getClass() + " which is not an instance of " + this.inputClass);
        }
        return this.evaluate(new Object[]{context});
    }

    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("profileContext", input[0], 100);
        scriptContext.setAttribute("input", input[0], 100);
    }

    @Nonnull
    static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceScript(engineName, resource, null);
    }

    @Nonnull
    static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource, @Nullable Class outputType) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript(engineName, is);
            ScriptedContextLookupFunction<ProfileRequestContext> scriptedContextLookupFunction = new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, resource.getDescription(), outputType);
            return scriptedContextLookupFunction;
        }
    }

    @Nonnull
    static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceScript("JavaScript", resource, null);
    }

    @Nonnull
    static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(Resource resource, @Nullable Class outputType) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceScript("JavaScript", resource, outputType);
    }

    @Nonnull
    static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline");
    }

    @Nonnull
    static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource, @Nullable Class outputType) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline", outputType);
    }

    @Nonnull
    static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript("JavaScript", scriptSource);
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline");
    }

    @Nonnull
    static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @NotEmpty String scriptSource, @Nullable Class outputType) throws ScriptException {
        EvaluableScript script = new EvaluableScript("JavaScript", scriptSource);
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline", outputType);
    }

    @Nonnull
    static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceMessageContextScript(engineName, resource, null);
    }

    @Nonnull
    static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource, @Nullable Class outputType) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript(engineName, is);
            ScriptedContextLookupFunction<MessageContext> scriptedContextLookupFunction = new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, resource.getDescription(), outputType);
            return scriptedContextLookupFunction;
        }
    }

    @Nonnull
    static ScriptedContextLookupFunction resourceMessageContextScript(Resource resource) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceMessageContextScript("JavaScript", resource, null);
    }

    @Nonnull
    static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(Resource resource, @Nullable Class outputType) throws ScriptException, IOException {
        return ScriptedContextLookupFunction.resourceMessageContextScript("JavaScript", resource, outputType);
    }

    @Nonnull
    static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline");
    }

    @Nonnull
    static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource, @Nullable Class outputType) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline", outputType);
    }

    @Nonnull
    static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript("JavaScript", scriptSource);
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline");
    }

    @Nonnull
    static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @NotEmpty String scriptSource, @Nullable Class outputType) throws ScriptException {
        EvaluableScript script = new EvaluableScript("JavaScript", scriptSource);
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline", outputType);
    }
}

