/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import net.shibboleth.idp.relyingparty.MockProfileConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RelyingPartyConfigurationTest {
    @Test
    public void testConstruction() throws ComponentInitializationException {
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setDetailedErrorsPredicate(Predicates.alwaysTrue());
        config.initialize();
        Assert.assertEquals((String)config.getId(), (String)"foo");
        Assert.assertEquals((String)config.getResponderId(), (String)"http://idp.example.org");
        Assert.assertTrue((boolean)config.isDetailedErrors());
        Assert.assertTrue((boolean)config.getDetailedErrorsPredicate().apply(null));
        Assert.assertTrue((boolean)config.getProfileConfigurations().isEmpty());
        config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setDetailedErrorsPredicate(Predicates.alwaysFalse());
        config.initialize();
        Assert.assertEquals((String)config.getId(), (String)"foo");
        Assert.assertEquals((String)config.getResponderId(), (String)"http://idp.example.org");
        Assert.assertFalse((boolean)config.isDetailedErrors());
        Assert.assertFalse((boolean)config.getDetailedErrorsPredicate().apply(null));
        Assert.assertTrue((boolean)config.getProfileConfigurations().isEmpty());
        ArrayList<MockProfileConfiguration> profileConfigs = new ArrayList<MockProfileConfiguration>();
        profileConfigs.add(new MockProfileConfiguration("foo"));
        profileConfigs.add(null);
        profileConfigs.add(new MockProfileConfiguration("bar"));
        config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setProfileConfigurations(profileConfigs);
        config.initialize();
        Assert.assertEquals((String)config.getId(), (String)"foo");
        Assert.assertEquals((String)config.getResponderId(), (String)"http://idp.example.org");
        Assert.assertEquals((int)config.getProfileConfigurations().size(), (int)2);
        try {
            config = new RelyingPartyConfiguration();
            config.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        try {
            config = new RelyingPartyConfiguration();
            config.setId("");
            config.initialize();
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testProfileConfiguration() throws ComponentInitializationException {
        ArrayList<MockProfileConfiguration> profileConfigs = new ArrayList<MockProfileConfiguration>();
        profileConfigs.add(new MockProfileConfiguration("foo"));
        profileConfigs.add(new MockProfileConfiguration("bar"));
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setProfileConfigurations(profileConfigs);
        config.initialize();
        Assert.assertNotNull((Object)config.getProfileConfiguration("foo"));
        Assert.assertNotNull((Object)config.getProfileConfiguration("bar"));
        Assert.assertNull((Object)config.getProfileConfiguration("baz"));
    }

    @Test
    public void testIndirectProfileConfiguration() throws ComponentInitializationException {
        HashMap<String, MockProfileConfiguration> profileConfigs = new HashMap<String, MockProfileConfiguration>();
        profileConfigs.put("foo", new MockProfileConfiguration("foo"));
        profileConfigs.put("bar", new MockProfileConfiguration("bar"));
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setProfileConfigurationsLookupStrategy(FunctionSupport.constant(profileConfigs));
        config.initialize();
        Assert.assertNotNull((Object)config.getProfileConfiguration("foo"));
        Assert.assertNotNull((Object)config.getProfileConfiguration("bar"));
        Assert.assertNull((Object)config.getProfileConfiguration("baz"));
        config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setProfileConfigurations(profileConfigs.values());
        config.setProfileConfigurationsLookupStrategy(FunctionSupport.constant(null));
        config.initialize();
        Assert.assertNotNull((Object)config.getProfileConfiguration("foo"));
        Assert.assertNotNull((Object)config.getProfileConfiguration("bar"));
        Assert.assertNull((Object)config.getProfileConfiguration("baz"));
    }

    @Test
    public void testIndirectResponderId() throws ComponentInitializationException {
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderIdLookupStrategy(FunctionSupport.constant((Object)"http://idp.example.org"));
        config.initialize();
        Assert.assertEquals((String)config.getResponderId(), (String)"http://idp.example.org");
        config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setResponderIdLookupStrategy(FunctionSupport.constant(null));
        config.initialize();
        Assert.assertEquals((String)config.getResponderId(), (String)"http://idp.example.org");
    }
}

