/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorResult;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractProfileInterceptorResultTest {
    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyContext() {
        new MockAbstractProfileInterceptorResult("", "key", "value", 100L);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyKey() {
        new MockAbstractProfileInterceptorResult("context", "", "value", 100L);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyValue() {
        new MockAbstractProfileInterceptorResult("context", "key", "", 100L);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullContext() {
        new MockAbstractProfileInterceptorResult(null, "key", "value", 100L);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullKey() {
        new MockAbstractProfileInterceptorResult("context", null, "value", 100L);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullValue() {
        new MockAbstractProfileInterceptorResult("context", "key", null, 100L);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNegativeExpiration() {
        new MockAbstractProfileInterceptorResult("context", "key", null, -100L);
    }

    @Test
    public void testNullExpiration() {
        MockAbstractProfileInterceptorResult result = new MockAbstractProfileInterceptorResult("context", "key", "value", null);
        Assert.assertEquals((String)result.getStorageContext(), (String)"context");
        Assert.assertEquals((String)result.getStorageKey(), (String)"key");
        Assert.assertEquals((String)result.getStorageValue(), (String)"value");
        Assert.assertEquals((Object)result.getStorageExpiration(), null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testZeroExpiration() {
        new MockAbstractProfileInterceptorResult("context", "key", null, 0L);
    }

    @Test
    public void testResult() {
        MockAbstractProfileInterceptorResult result = new MockAbstractProfileInterceptorResult("context", "key", "value", 100L);
        Assert.assertEquals((String)result.getStorageContext(), (String)"context");
        Assert.assertEquals((String)result.getStorageKey(), (String)"key");
        Assert.assertEquals((String)result.getStorageValue(), (String)"value");
        Assert.assertEquals((Object)result.getStorageExpiration(), (Object)100L);
    }

    private class MockAbstractProfileInterceptorResult
    extends AbstractProfileInterceptorResult {
        public MockAbstractProfileInterceptorResult(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable @Duration @Positive String value, Long expiration) {
            super(context, key, value, expiration);
        }
    }
}

