/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpringExpressionContextLookupFunction<T extends BaseContext>
implements ContextDataLookupFunction<T, Object> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionContextLookupFunction.class);
    @Nullable
    private String springExpression;
    @Nullable
    private Class outputClass;
    @Nonnull
    private final Class<T> inputClass;
    @Nullable
    private Object customObject;
    private boolean hideExceptions;

    public SpringExpressionContextLookupFunction(@Nonnull @ParameterName(name="inClass") Class<T> inClass, @Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        this.inputClass = (Class)Constraint.isNotNull(inClass, (String)"Supplied inputClass cannot be null");
        this.springExpression = (String)Constraint.isNotNull((Object)expression, (String)"Supplied expression cannot be null");
    }

    public SpringExpressionContextLookupFunction(@Nonnull @ParameterName(name="inClass") Class<T> inClass, @Nonnull @ParameterName(name="expression") @NotEmpty String expression, @ParameterName(name="outputType") @Nullable Class outputType) {
        this(inClass, expression);
        this.outputClass = outputType;
    }

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    @Nullable
    public void setCustomObject(Object object) {
        this.customObject = object;
    }

    public void setHideExceptions(boolean flag) {
        this.hideExceptions = flag;
    }

    public Object apply(@Nullable T context) {
        if (null != context && !this.inputClass.isInstance(context)) {
            throw new ClassCastException("Input was type " + context.getClass() + " which is not an instance of " + this.inputClass);
        }
        try {
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext eval = new StandardEvaluationContext();
            eval.setVariable("custom", this.customObject);
            eval.setVariable("input", context);
            Object output = parser.parseExpression(this.springExpression).getValue((EvaluationContext)eval);
            if (null != this.outputClass && null != output && !this.outputClass.isInstance(output)) {
                this.log.error("Output of type {} was not of type {}", output.getClass(), (Object)this.outputClass);
                return null;
            }
            return output;
        }
        catch (EvaluationException | ParseException e) {
            this.log.error("Error evaluating Spring expression", e);
            if (this.hideExceptions) {
                return null;
            }
            throw e;
        }
    }
}

